/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.tracing.opentelemetry.autoconfigure.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracingExport;
import org.springframework.context.annotation.Bean;
import zipkin2.Span;
import zipkin2.reporter.BytesEncoder;
import zipkin2.reporter.BytesMessageSender;
import zipkin2.reporter.Encoding;
import zipkin2.reporter.SpanBytesEncoder;

@AutoConfiguration(afterName={"org.springframework.boot.zipkin.autoconfigure.ZipkinAutoConfiguration"})
@ConditionalOnClass(value={ZipkinSpanExporter.class, Span.class})
public final class ZipkinWithOpenTelemetryTracingAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={Encoding.class})
    @ConditionalOnMissingBean(value={Span.class}, parameterizedContainer={BytesEncoder.class})
    BytesEncoder<Span> spanBytesEncoder(Encoding encoding) {
        return SpanBytesEncoder.forEncoding((Encoding)encoding);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={BytesMessageSender.class})
    @ConditionalOnEnabledTracingExport(value="zipkin")
    ZipkinSpanExporter zipkinSpanExporter(BytesMessageSender sender, BytesEncoder<Span> spanBytesEncoder) {
        return ZipkinSpanExporter.builder().setSender(sender).setEncoder(spanBytesEncoder).build();
    }
}

