/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.testcontainers;

import com.mongodb.ConnectionString;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.containers.GenericContainer;

abstract class AbstractMongoContainerConnectionDetailsFactory<T extends GenericContainer<T>>
extends ContainerConnectionDetailsFactory<T, MongoConnectionDetails> {
    private final Function<T, String> connectionStringFunction;

    AbstractMongoContainerConnectionDetailsFactory(Function<T, String> connectionStringFunction) {
        super(ANY_CONNECTION_NAME, new String[]{"com.mongodb.ConnectionString"});
        this.connectionStringFunction = connectionStringFunction;
    }

    protected MongoConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<T> source) {
        return new MongoContainerConnectionDetails<T>(source, this.connectionStringFunction);
    }

    private static final class MongoContainerConnectionDetails<T extends GenericContainer<T>>
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<T>
    implements MongoConnectionDetails {
        private final Function<T, String> connectionStringFunction;

        private MongoContainerConnectionDetails(ContainerConnectionSource<T> source, Function<T, String> connectionStringFunction) {
            super(source);
            this.connectionStringFunction = connectionStringFunction;
        }

        @Override
        public ConnectionString getConnectionString() {
            return new ConnectionString(this.connectionStringFunction.apply((GenericContainer)this.getContainer()));
        }

        @Override
        public @Nullable SslBundle getSslBundle() {
            return super.getSslBundle();
        }
    }
}

