/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.autoconfigure.HttpClientAutoConfiguration;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.restclient.RestTemplateBuilder;
import org.springframework.boot.restclient.RestTemplateCustomizer;
import org.springframework.boot.restclient.RestTemplateRequestCustomizer;
import org.springframework.boot.restclient.autoconfigure.NotReactiveWebApplicationCondition;
import org.springframework.boot.restclient.autoconfigure.RestTemplateBuilderConfigurer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={HttpClientAutoConfiguration.class})
@ConditionalOnClass(value={RestTemplate.class, HttpMessageConverters.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
public class RestTemplateAutoConfiguration {
    @Bean
    @Lazy
    public RestTemplateBuilderConfigurer restTemplateBuilderConfigurer(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings, ObjectProvider<HttpMessageConverters> messageConverters, ObjectProvider<RestTemplateCustomizer> restTemplateCustomizers, ObjectProvider<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers) {
        RestTemplateBuilderConfigurer configurer = new RestTemplateBuilderConfigurer();
        configurer.setRequestFactoryBuilder((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable());
        configurer.setRequestFactorySettings((ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable());
        configurer.setHttpMessageConverters((HttpMessageConverters)messageConverters.getIfUnique());
        configurer.setRestTemplateCustomizers(restTemplateCustomizers.orderedStream().toList());
        configurer.setRestTemplateRequestCustomizers(restTemplateRequestCustomizers.orderedStream().toList());
        return configurer;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public RestTemplateBuilder restTemplateBuilder(RestTemplateBuilderConfigurer restTemplateBuilderConfigurer) {
        return restTemplateBuilderConfigurer.configure(new RestTemplateBuilder(new RestTemplateCustomizer[0]));
    }
}

