/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.oauth2.server.resource.autoconfigure;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.source.InvalidConfigurationPropertyValueException;
import org.springframework.core.io.Resource;
import org.springframework.util.StreamUtils;

@ConfigurationProperties(value="spring.security.oauth2.resourceserver")
public class OAuth2ResourceServerProperties {
    private final Jwt jwt = new Jwt();
    private final Opaquetoken opaquetoken = new Opaquetoken();

    public Jwt getJwt() {
        return this.jwt;
    }

    public Opaquetoken getOpaquetoken() {
        return this.opaquetoken;
    }

    public static class Jwt {
        private @Nullable String jwkSetUri;
        private List<String> jwsAlgorithms = Arrays.asList("RS256");
        private @Nullable String issuerUri;
        private @Nullable Resource publicKeyLocation;
        private List<String> audiences = new ArrayList<String>();
        private @Nullable String authorityPrefix;
        private @Nullable String authoritiesClaimDelimiter;
        private @Nullable String authoritiesClaimName;
        private @Nullable String principalClaimName;

        public @Nullable String getJwkSetUri() {
            return this.jwkSetUri;
        }

        public void setJwkSetUri(@Nullable String jwkSetUri) {
            this.jwkSetUri = jwkSetUri;
        }

        public List<String> getJwsAlgorithms() {
            return this.jwsAlgorithms;
        }

        public void setJwsAlgorithms(List<String> jwsAlgorithms) {
            this.jwsAlgorithms = jwsAlgorithms;
        }

        public @Nullable String getIssuerUri() {
            return this.issuerUri;
        }

        public void setIssuerUri(@Nullable String issuerUri) {
            this.issuerUri = issuerUri;
        }

        public @Nullable Resource getPublicKeyLocation() {
            return this.publicKeyLocation;
        }

        public void setPublicKeyLocation(@Nullable Resource publicKeyLocation) {
            this.publicKeyLocation = publicKeyLocation;
        }

        public List<String> getAudiences() {
            return this.audiences;
        }

        public void setAudiences(List<String> audiences) {
            this.audiences = audiences;
        }

        public @Nullable String getAuthorityPrefix() {
            return this.authorityPrefix;
        }

        public void setAuthorityPrefix(@Nullable String authorityPrefix) {
            this.authorityPrefix = authorityPrefix;
        }

        public @Nullable String getAuthoritiesClaimDelimiter() {
            return this.authoritiesClaimDelimiter;
        }

        public void setAuthoritiesClaimDelimiter(@Nullable String authoritiesClaimDelimiter) {
            this.authoritiesClaimDelimiter = authoritiesClaimDelimiter;
        }

        public @Nullable String getAuthoritiesClaimName() {
            return this.authoritiesClaimName;
        }

        public void setAuthoritiesClaimName(@Nullable String authoritiesClaimName) {
            this.authoritiesClaimName = authoritiesClaimName;
        }

        public @Nullable String getPrincipalClaimName() {
            return this.principalClaimName;
        }

        public void setPrincipalClaimName(@Nullable String principalClaimName) {
            this.principalClaimName = principalClaimName;
        }

        public String readPublicKey() throws IOException {
            String key = "spring.security.oauth2.resourceserver.jwt.public-key-location";
            if (this.publicKeyLocation == null) {
                throw new InvalidConfigurationPropertyValueException(key, (Object)this.publicKeyLocation, "No public key location specified");
            }
            if (!this.publicKeyLocation.exists()) {
                throw new InvalidConfigurationPropertyValueException(key, (Object)this.publicKeyLocation, "Public key location does not exist");
            }
            try (InputStream inputStream = this.publicKeyLocation.getInputStream();){
                String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                return string;
            }
        }
    }

    public static class Opaquetoken {
        private @Nullable String clientId;
        private @Nullable String clientSecret;
        private @Nullable String introspectionUri;

        public @Nullable String getClientId() {
            return this.clientId;
        }

        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        public @Nullable String getClientSecret() {
            return this.clientSecret;
        }

        public void setClientSecret(@Nullable String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public @Nullable String getIntrospectionUri() {
            return this.introspectionUri;
        }

        public void setIntrospectionUri(@Nullable String introspectionUri) {
            this.introspectionUri = introspectionUri;
        }
    }
}

