/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.security.autoconfigure.SecurityProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.data.repository.query.SecurityEvaluationContextExtension;

@AutoConfiguration
@ConditionalOnClass(value={DefaultAuthenticationEventPublisher.class})
@EnableConfigurationProperties(value={SecurityProperties.class})
public final class SecurityAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AuthenticationEventPublisher.class})
    DefaultAuthenticationEventPublisher authenticationEventPublisher(ApplicationEventPublisher publisher) {
        return new DefaultAuthenticationEventPublisher(publisher);
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SecurityEvaluationContextExtension.class})
    static class SecurityDataConfiguration {
        SecurityDataConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        SecurityEvaluationContextExtension securityEvaluationContextExtension() {
            return new SecurityEvaluationContextExtension();
        }
    }
}

