/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.restdocs;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcBuilderCustomizer;
import org.springframework.restdocs.mockmvc.MockMvcRestDocumentationConfigurer;
import org.springframework.restdocs.mockmvc.RestDocumentationResultHandler;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.setup.ConfigurableMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcConfigurer;
import org.springframework.util.StringUtils;

class RestDocsMockMvcBuilderCustomizer
implements InitializingBean,
MockMvcBuilderCustomizer {
    private final MockMvcRestDocumentationConfigurer delegate;
    private final RestDocumentationResultHandler resultHandler;
    private String uriScheme;
    private String uriHost;
    private Integer uriPort;

    RestDocsMockMvcBuilderCustomizer(MockMvcRestDocumentationConfigurer delegate, RestDocumentationResultHandler resultHandler) {
        this.delegate = delegate;
        this.resultHandler = resultHandler;
    }

    public String getUriScheme() {
        return this.uriScheme;
    }

    public void setUriScheme(String uriScheme) {
        this.uriScheme = uriScheme;
    }

    public String getUriHost() {
        return this.uriHost;
    }

    public void setUriHost(String uriHost) {
        this.uriHost = uriHost;
    }

    public Integer getUriPort() {
        return this.uriPort;
    }

    public void setUriPort(Integer uriPort) {
        this.uriPort = uriPort;
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.uriScheme)) {
            this.delegate.uris().withScheme(this.uriScheme);
        }
        if (StringUtils.hasText((String)this.uriHost)) {
            this.delegate.uris().withHost(this.uriHost);
        }
        if (this.uriPort != null) {
            this.delegate.uris().withPort(this.uriPort.intValue());
        }
    }

    @Override
    public void customize(ConfigurableMockMvcBuilder<?> builder) {
        builder.apply((MockMvcConfigurer)this.delegate);
        if (this.resultHandler != null) {
            builder.alwaysDo((ResultHandler)this.resultHandler);
        }
    }
}

