/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthorizationInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriTemplateHandler;

public class TestRestTemplate {
    private final RestTemplate restTemplate;
    private final HttpClientOption[] httpClientOptions;

    public TestRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        this(TestRestTemplate.buildRestTemplate(restTemplateBuilder));
    }

    public TestRestTemplate(HttpClientOption ... httpClientOptions) {
        this((String)null, (String)null, httpClientOptions);
    }

    public TestRestTemplate(String username, String password, HttpClientOption ... httpClientOptions) {
        this(new RestTemplate(), username, password, httpClientOptions);
    }

    public TestRestTemplate(RestTemplate restTemplate) {
        this(restTemplate, null, null, new HttpClientOption[0]);
    }

    public TestRestTemplate(RestTemplate restTemplate, String username, String password, HttpClientOption ... httpClientOptions) {
        Assert.notNull((Object)restTemplate, (String)"RestTemplate must not be null");
        this.httpClientOptions = httpClientOptions;
        if (ClassUtils.isPresent((String)"org.apache.http.client.config.RequestConfig", null)) {
            restTemplate.setRequestFactory((ClientHttpRequestFactory)new CustomHttpComponentsClientHttpRequestFactory(httpClientOptions));
        }
        this.addAuthentication(restTemplate, username, password);
        restTemplate.setErrorHandler((ResponseErrorHandler)new NoOpResponseErrorHandler());
        this.restTemplate = restTemplate;
    }

    private static RestTemplate buildRestTemplate(RestTemplateBuilder restTemplateBuilder) {
        Assert.notNull((Object)restTemplateBuilder, (String)"RestTemplateBuilder must not be null");
        return restTemplateBuilder.build();
    }

    private void addAuthentication(RestTemplate restTemplate, String username, String password) {
        if (username == null) {
            return;
        }
        List interceptors = restTemplate.getInterceptors();
        if (interceptors == null) {
            interceptors = Collections.emptyList();
        }
        interceptors = new ArrayList(interceptors);
        Iterator iterator = interceptors.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof BasicAuthorizationInterceptor)) continue;
            iterator.remove();
        }
        interceptors.add(new BasicAuthorizationInterceptor(username, password));
        restTemplate.setInterceptors(interceptors);
    }

    public void setUriTemplateHandler(UriTemplateHandler handler) {
        this.restTemplate.setUriTemplateHandler(handler);
    }

    public <T> T getForObject(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return (T)this.restTemplate.getForObject(url, responseType, urlVariables);
    }

    public <T> T getForObject(URI url, Class<T> responseType) throws RestClientException {
        return (T)this.restTemplate.getForObject(this.applyRootUriIfNecessary(url), responseType);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(String url, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.getForEntity(url, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> getForEntity(URI url, Class<T> responseType) throws RestClientException {
        return this.restTemplate.getForEntity(this.applyRootUriIfNecessary(url), responseType);
    }

    public HttpHeaders headForHeaders(String url, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(String url, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.headForHeaders(url, urlVariables);
    }

    public HttpHeaders headForHeaders(URI url) throws RestClientException {
        return this.restTemplate.headForHeaders(this.applyRootUriIfNecessary(url));
    }

    public URI postForLocation(String url, Object request, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(String url, Object request, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.postForLocation(url, request, urlVariables);
    }

    public URI postForLocation(URI url, Object request) throws RestClientException {
        return this.restTemplate.postForLocation(this.applyRootUriIfNecessary(url), request);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> T postForObject(String url, Object request, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return (T)this.restTemplate.postForObject(url, request, responseType, urlVariables);
    }

    public <T> T postForObject(URI url, Object request, Class<T> responseType) throws RestClientException {
        return (T)this.restTemplate.postForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(String url, Object request, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.postForEntity(url, request, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> postForEntity(URI url, Object request, Class<T> responseType) throws RestClientException {
        return this.restTemplate.postForEntity(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void put(String url, Object request, Object ... urlVariables) throws RestClientException {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(String url, Object request, Map<String, ?> urlVariables) throws RestClientException {
        this.restTemplate.put(url, request, urlVariables);
    }

    public void put(URI url, Object request) throws RestClientException {
        this.restTemplate.put(this.applyRootUriIfNecessary(url), request);
    }

    public <T> T patchForObject(String url, Object request, Class<T> responseType, Object ... uriVariables) throws RestClientException {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> T patchForObject(String url, Object request, Class<T> responseType, Map<String, ?> uriVariables) throws RestClientException {
        return (T)this.restTemplate.patchForObject(url, request, responseType, uriVariables);
    }

    public <T> T patchForObject(URI url, Object request, Class<T> responseType) throws RestClientException {
        return (T)this.restTemplate.patchForObject(this.applyRootUriIfNecessary(url), request, responseType);
    }

    public void delete(String url, Object ... urlVariables) throws RestClientException {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(String url, Map<String, ?> urlVariables) throws RestClientException {
        this.restTemplate.delete(url, urlVariables);
    }

    public void delete(URI url) throws RestClientException {
        this.restTemplate.delete(this.applyRootUriIfNecessary(url));
    }

    public Set<HttpMethod> optionsForAllow(String url, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(String url, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.optionsForAllow(url, urlVariables);
    }

    public Set<HttpMethod> optionsForAllow(URI url) throws RestClientException {
        return this.restTemplate.optionsForAllow(this.applyRootUriIfNecessary(url));
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Object ... urlVariables) throws RestClientException {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(String url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType, Map<String, ?> urlVariables) throws RestClientException {
        return this.restTemplate.exchange(url, method, requestEntity, responseType, urlVariables);
    }

    public <T> ResponseEntity<T> exchange(URI url, HttpMethod method, HttpEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        return this.restTemplate.exchange(this.applyRootUriIfNecessary(url), method, requestEntity, responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, Class<T> responseType) throws RestClientException {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> ResponseEntity<T> exchange(RequestEntity<?> requestEntity, ParameterizedTypeReference<T> responseType) throws RestClientException {
        return this.restTemplate.exchange(this.createRequestEntityWithRootAppliedUri(requestEntity), responseType);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Object ... urlVariables) throws RestClientException {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(String url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor, Map<String, ?> urlVariables) throws RestClientException {
        return (T)this.restTemplate.execute(url, method, requestCallback, responseExtractor, urlVariables);
    }

    public <T> T execute(URI url, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)this.restTemplate.execute(this.applyRootUriIfNecessary(url), method, requestCallback, responseExtractor);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public TestRestTemplate withBasicAuth(String username, String password) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.setMessageConverters(this.getRestTemplate().getMessageConverters());
        restTemplate.setInterceptors(this.getRestTemplate().getInterceptors());
        restTemplate.setRequestFactory(this.getRestTemplate().getRequestFactory());
        restTemplate.setUriTemplateHandler(this.getRestTemplate().getUriTemplateHandler());
        TestRestTemplate testRestTemplate = new TestRestTemplate(restTemplate, username, password, this.httpClientOptions);
        testRestTemplate.getRestTemplate().setErrorHandler(this.getRestTemplate().getErrorHandler());
        return testRestTemplate;
    }

    private RequestEntity<?> createRequestEntityWithRootAppliedUri(RequestEntity<?> requestEntity) {
        return new RequestEntity(requestEntity.getBody(), (MultiValueMap)requestEntity.getHeaders(), requestEntity.getMethod(), this.applyRootUriIfNecessary(requestEntity.getUrl()), requestEntity.getType());
    }

    private URI applyRootUriIfNecessary(URI uri) {
        UriTemplateHandler uriTemplateHandler = this.restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof RootUriTemplateHandler && uri.toString().startsWith("/")) {
            return URI.create(((RootUriTemplateHandler)uriTemplateHandler).getRootUri() + uri.toString());
        }
        return uri;
    }

    private static class NoOpResponseErrorHandler
    extends DefaultResponseErrorHandler {
        private NoOpResponseErrorHandler() {
        }

        public void handleError(ClientHttpResponse response) throws IOException {
        }
    }

    protected static class CustomHttpComponentsClientHttpRequestFactory
    extends HttpComponentsClientHttpRequestFactory {
        private final String cookieSpec;
        private final boolean enableRedirects;

        public CustomHttpComponentsClientHttpRequestFactory(HttpClientOption[] httpClientOptions) {
            HashSet<HttpClientOption> options = new HashSet<HttpClientOption>(Arrays.asList(httpClientOptions));
            this.cookieSpec = options.contains((Object)HttpClientOption.ENABLE_COOKIES) ? "standard" : "ignoreCookies";
            this.enableRedirects = options.contains((Object)HttpClientOption.ENABLE_REDIRECTS);
            if (options.contains((Object)HttpClientOption.SSL)) {
                this.setHttpClient(this.createSslHttpClient());
            }
        }

        private HttpClient createSslHttpClient() {
            try {
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build());
                return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).build();
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to create SSL HttpClient", ex);
            }
        }

        protected HttpContext createHttpContext(HttpMethod httpMethod, URI uri) {
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(this.getRequestConfig());
            return context;
        }

        protected RequestConfig getRequestConfig() {
            RequestConfig.Builder builder = RequestConfig.custom().setCookieSpec(this.cookieSpec).setAuthenticationEnabled(false).setRedirectsEnabled(this.enableRedirects);
            return builder.build();
        }
    }

    public static enum HttpClientOption {
        ENABLE_COOKIES,
        ENABLE_REDIRECTS,
        SSL;

    }
}

