/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.embedded.tomcat.TomcatReactiveWebServerFactory;
import org.springframework.boot.web.reactive.context.ReactiveWebApplicationContext;
import org.springframework.boot.web.reactive.server.ReactiveWebServerFactory;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.server.adapter.WebHttpHandlerBuilder;
import reactor.core.publisher.Mono;

public abstract class AbstractSpringBootTestEmbeddedReactiveWebEnvironmentTests {
    @LocalServerPort
    private int port = 0;
    @Value(value="${value}")
    private int value = 0;
    @Autowired
    private ReactiveWebApplicationContext context;
    @Autowired
    private WebTestClient webClient;
    @Autowired
    private TestRestTemplate restTemplate;

    public ReactiveWebApplicationContext getContext() {
        return this.context;
    }

    @Test
    public void runAndTestHttpEndpoint() {
        Assertions.assertThat((int)this.port).isNotEqualTo(8080).isNotEqualTo(0);
        WebTestClient.bindToServer().baseUrl("http://localhost:" + this.port).build().get().uri("/", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"Hello World");
    }

    @Test
    public void injectWebTestClient() {
        this.webClient.get().uri("/", new Object[0]).exchange().expectBody(String.class).isEqualTo((Object)"Hello World");
    }

    @Test
    public void injectTestRestTemplate() {
        String body = (String)this.restTemplate.getForObject("/", String.class, new Object[0]);
        Assertions.assertThat((String)body).isEqualTo((Object)"Hello World");
    }

    @Test
    public void annotationAttributesOverridePropertiesFile() {
        Assertions.assertThat((int)this.value).isEqualTo(123);
    }

    protected static abstract class AbstractConfig {
        @Value(value="${server.port:8080}")
        private int port = 8080;

        protected AbstractConfig() {
        }

        @Bean
        public HttpHandler httpHandler(ApplicationContext applicationContext) {
            return WebHttpHandlerBuilder.applicationContext((ApplicationContext)applicationContext).build();
        }

        @Bean
        public ReactiveWebServerFactory webServerFactory() {
            TomcatReactiveWebServerFactory factory = new TomcatReactiveWebServerFactory();
            factory.setPort(this.port);
            return factory;
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyPlaceholder() {
            return new PropertySourcesPlaceholderConfigurer();
        }

        @RequestMapping(value={"/"})
        public Mono<String> home() {
            return Mono.just((Object)"Hello World");
        }
    }
}

