/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.Set;
import kotlin.Metadata;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.spockframework.runtime.model.SpecMetadata;
import org.springframework.boot.context.annotation.DeterminableImports;
import org.springframework.boot.test.context.ImportsContextCustomizer;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import spock.lang.Issue;
import spock.lang.Stepwise;

public class ImportsContextCustomizerTests {
    @Test
    public void importSelectorsCouldUseAnyAnnotations() {
        Assertions.assertThat((Object)new ImportsContextCustomizer(FirstImportSelectorAnnotatedClass.class)).isNotEqualTo((Object)new ImportsContextCustomizer(SecondImportSelectorAnnotatedClass.class));
    }

    @Test
    public void determinableImportSelector() {
        Assertions.assertThat((Object)new ImportsContextCustomizer(FirstDeterminableImportSelectorAnnotatedClass.class)).isEqualTo((Object)new ImportsContextCustomizer(SecondDeterminableImportSelectorAnnotatedClass.class));
    }

    @Test
    public void customizersForTestClassesWithDifferentKotlinMetadataAreEqual() {
        Assertions.assertThat((Object)new ImportsContextCustomizer(FirstKotlinAnnotatedTestClass.class)).isEqualTo((Object)new ImportsContextCustomizer(SecondKotlinAnnotatedTestClass.class));
    }

    @Test
    public void customizersForTestClassesWithDifferentSpockFrameworkAnnotationsAreEqual() {
        Assertions.assertThat((Object)new ImportsContextCustomizer(FirstSpockFrameworkAnnotatedTestClass.class)).isEqualTo((Object)new ImportsContextCustomizer(SecondSpockFrameworkAnnotatedTestClass.class));
    }

    @Test
    public void customizersForTestClassesWithDifferentSpockLangAnnotationsAreEqual() {
        Assertions.assertThat((Object)new ImportsContextCustomizer(FirstSpockLangAnnotatedTestClass.class)).isEqualTo((Object)new ImportsContextCustomizer(SecondSpockLangAnnotatedTestClass.class));
    }

    @Configuration
    static class TestConfig {
        TestConfig() {
        }
    }

    static class TestDeterminableImportSelector
    implements ImportSelector,
    DeterminableImports {
        TestDeterminableImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata arg0) {
            return new String[]{TestConfig.class.getName()};
        }

        public Set<Object> determineImports(AnnotationMetadata metadata) {
            return Collections.singleton(TestConfig.class.getName());
        }
    }

    static class TestImportSelector
    implements ImportSelector {
        TestImportSelector() {
        }

        public String[] selectImports(AnnotationMetadata arg0) {
            return new String[0];
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Indicator2 {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Indicator1 {
    }

    @Issue(value={"1234"})
    static class SecondSpockLangAnnotatedTestClass {
        SecondSpockLangAnnotatedTestClass() {
        }
    }

    @Stepwise
    static class FirstSpockLangAnnotatedTestClass {
        FirstSpockLangAnnotatedTestClass() {
        }
    }

    @SpecMetadata(filename="bar", line=10)
    static class SecondSpockFrameworkAnnotatedTestClass {
        SecondSpockFrameworkAnnotatedTestClass() {
        }
    }

    @SpecMetadata(filename="foo", line=10)
    static class FirstSpockFrameworkAnnotatedTestClass {
        FirstSpockFrameworkAnnotatedTestClass() {
        }
    }

    @Metadata(d2={"bar"})
    static class SecondKotlinAnnotatedTestClass {
        SecondKotlinAnnotatedTestClass() {
        }
    }

    @Metadata(d2={"foo"})
    static class FirstKotlinAnnotatedTestClass {
        FirstKotlinAnnotatedTestClass() {
        }
    }

    @Import(value={TestDeterminableImportSelector.class})
    @Indicator2
    static class SecondDeterminableImportSelectorAnnotatedClass {
        SecondDeterminableImportSelectorAnnotatedClass() {
        }
    }

    @Import(value={TestDeterminableImportSelector.class})
    @Indicator1
    static class FirstDeterminableImportSelectorAnnotatedClass {
        FirstDeterminableImportSelectorAnnotatedClass() {
        }
    }

    @Import(value={TestImportSelector.class})
    @Indicator2
    static class SecondImportSelectorAnnotatedClass {
        SecondImportSelectorAnnotatedClass() {
        }
    }

    @Import(value={TestImportSelector.class})
    @Indicator1
    static class FirstImportSelectorAnnotatedClass {
        FirstImportSelectorAnnotatedClass() {
        }
    }
}

