/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.Map;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.util.ReflectionTestUtils;

public class SpringBootContextLoaderTests {
    @Test
    public void environmentPropertiesSimple() {
        Map<String, Object> config = this.getEnvironmentProperties(SimpleConfig.class);
        this.assertKey(config, "key", "myValue");
        this.assertKey(config, "anotherKey", "anotherValue");
    }

    @Test
    public void environmentPropertiesSimpleNonAlias() {
        Map<String, Object> config = this.getEnvironmentProperties(SimpleConfigNonAlias.class);
        this.assertKey(config, "key", "myValue");
        this.assertKey(config, "anotherKey", "anotherValue");
    }

    @Test
    public void environmentPropertiesOverrideDefaults() {
        Map<String, Object> config = this.getEnvironmentProperties(OverrideConfig.class);
        this.assertKey(config, "server.port", "2345");
    }

    @Test
    public void environmentPropertiesAppend() {
        Map<String, Object> config = this.getEnvironmentProperties(AppendConfig.class);
        this.assertKey(config, "key", "myValue");
        this.assertKey(config, "otherKey", "otherValue");
    }

    @Test
    public void environmentPropertiesSeparatorInValue() {
        Map<String, Object> config = this.getEnvironmentProperties(SameSeparatorInValue.class);
        this.assertKey(config, "key", "my=Value");
        this.assertKey(config, "anotherKey", "another:Value");
    }

    @Test
    public void environmentPropertiesAnotherSeparatorInValue() {
        Map<String, Object> config = this.getEnvironmentProperties(AnotherSeparatorInValue.class);
        this.assertKey(config, "key", "my:Value");
        this.assertKey(config, "anotherKey", "another=Value");
    }

    @Test
    @Ignore
    public void environmentPropertiesNewLineInValue() {
        Map<String, Object> config = this.getEnvironmentProperties(NewLineInValue.class);
        this.assertKey(config, "key", "myValue");
        this.assertKey(config, "variables", "foo=FOO\n bar=BAR");
    }

    private Map<String, Object> getEnvironmentProperties(Class<?> testClass) {
        TestContext context = new ExposedTestContextManager(testClass).getExposedTestContext();
        MergedContextConfiguration config = (MergedContextConfiguration)ReflectionTestUtils.getField((Object)context, (String)"mergedContextConfiguration");
        return TestPropertySourceUtils.convertInlinedPropertiesToMap((String[])config.getPropertySourceProperties());
    }

    private void assertKey(Map<String, Object> actual, String key, Object value) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actual.containsKey(key)).as("Key '" + key + "' not found", new Object[0])).isTrue();
        Assertions.assertThat((Object)actual.get(key)).isEqualTo(value);
    }

    private static class ExposedTestContextManager
    extends TestContextManager {
        ExposedTestContextManager(Class<?> testClass) {
            super(testClass);
        }

        public final TestContext getExposedTestContext() {
            return super.getTestContext();
        }
    }

    @Configuration
    static class Config {
        Config() {
        }
    }

    @SpringBootTest(value={"key=myValue", "variables=foo=FOO\n bar=BAR"})
    @ContextConfiguration(classes={Config.class})
    static class NewLineInValue {
        NewLineInValue() {
        }
    }

    @SpringBootTest(value={"key=my:Value", "anotherKey:another=Value"})
    @ContextConfiguration(classes={Config.class})
    static class AnotherSeparatorInValue {
        AnotherSeparatorInValue() {
        }
    }

    @SpringBootTest(value={"key=my=Value", "anotherKey:another:Value"})
    @ContextConfiguration(classes={Config.class})
    static class SameSeparatorInValue {
        SameSeparatorInValue() {
        }
    }

    @SpringBootTest(value={"key=myValue", "otherKey=otherValue"})
    @ContextConfiguration(classes={Config.class})
    static class AppendConfig {
        AppendConfig() {
        }
    }

    @SpringBootTest(value={"server.port=2345"})
    @ContextConfiguration(classes={Config.class})
    static class OverrideConfig {
        OverrideConfig() {
        }
    }

    @SpringBootTest(properties={"key=myValue", "anotherKey:anotherValue"})
    @ContextConfiguration(classes={Config.class})
    static class SimpleConfigNonAlias {
        SimpleConfigNonAlias() {
        }
    }

    @SpringBootTest(value={"key=myValue", "anotherKey:anotherValue"})
    @ContextConfiguration(classes={Config.class})
    static class SimpleConfig {
        SimpleConfig() {
        }
    }
}

