/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.AbstractSpringBootTestWebServerWebEnvironmentTests;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, properties={"server.port=0", "value=123"})
@ContextHierarchy(value={@ContextConfiguration(classes={ParentConfiguration.class}), @ContextConfiguration(classes={ChildConfiguration.class})})
public class SpringBootTestWebEnvironmentContextHierarchyTests {
    @Autowired
    private ApplicationContext context;

    @Test
    public void testShouldOnlyStartSingleServer() {
        ApplicationContext parent = this.context.getParent();
        Assertions.assertThat((Object)this.context).isInstanceOf(WebApplicationContext.class);
        Assertions.assertThat((Object)parent).isNotInstanceOf(WebApplicationContext.class);
    }

    @Configuration
    @EnableWebMvc
    @RestController
    protected static class ChildConfiguration
    extends AbstractSpringBootTestWebServerWebEnvironmentTests.AbstractConfig {
        protected ChildConfiguration() {
        }
    }

    @Configuration
    protected static class ParentConfiguration
    extends AbstractSpringBootTestWebServerWebEnvironmentTests.AbstractConfig {
        protected ParentConfiguration() {
        }
    }
}

