/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.assertj;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.AssertableApplicationContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.StaticApplicationContext;

public class ApplicationContextAssertTests {
    private StaticApplicationContext parent;
    private StaticApplicationContext context;
    private RuntimeException failure = new RuntimeException();

    @Before
    public void setup() {
        this.parent = new StaticApplicationContext();
        this.context = new StaticApplicationContext();
        this.context.setParent((ApplicationContext)this.parent);
    }

    @After
    public void cleanup() {
        this.context.close();
        this.parent.close();
    }

    @Test
    public void createWhenApplicationContextIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new ApplicationContextAssert(null, null)).withMessageContaining("ApplicationContext must not be null");
    }

    @Test
    public void createWhenHasApplicationContextShouldSetActual() {
        Assertions.assertThat((Object)this.getAssert((ConfigurableApplicationContext)this.context).getSourceApplicationContext()).isSameAs((Object)this.context);
    }

    @Test
    public void createWhenHasExceptionShouldSetFailure() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getFailure().isSameAs((Object)this.failure);
    }

    @Test
    public void hasBeanWhenHasBeanShouldPass() {
        this.context.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasBean("foo");
    }

    @Test
    public void hasBeanWhenHasNoBeanShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasBean("foo")).withMessageContaining("no such bean");
    }

    @Test
    public void hasBeanWhenNotStartedShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).hasBean("foo")).withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void hasSingleBeanWhenHasSingleBeanShouldPass() {
        this.context.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasSingleBean(Foo.class);
    }

    @Test
    public void hasSingleBeanWhenHasNoBeansShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasSingleBean(Foo.class)).withMessageContaining("to have a single bean of type");
    }

    @Test
    public void hasSingleBeanWhenHasMultipleShouldFail() {
        this.context.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasSingleBean(Foo.class)).withMessageContaining("but found:");
    }

    @Test
    public void hasSingleBeanWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).hasSingleBean(Foo.class)).withMessageContaining("to have a single bean of type").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void hasSingleBeanWhenInParentShouldFail() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasSingleBean(Foo.class)).withMessageContaining("but found:");
    }

    @Test
    public void hasSingleBeanWithLimitedScopeWhenInParentShouldPass() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasSingleBean(Foo.class, ApplicationContextAssert.Scope.NO_ANCESTORS);
    }

    @Test
    public void doesNotHaveBeanOfTypeWhenHasNoBeanOfTypeShouldPass() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean(Foo.class);
    }

    @Test
    public void doesNotHaveBeanOfTypeWhenHasBeanOfTypeShouldFail() {
        this.context.registerSingleton("foo", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean(Foo.class)).withMessageContaining("but found");
    }

    @Test
    public void doesNotHaveBeanOfTypeWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).doesNotHaveBean(Foo.class)).withMessageContaining("not to have any beans of type").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void doesNotHaveBeanOfTypeWhenInParentShouldFail() {
        this.parent.registerSingleton("foo", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean(Foo.class)).withMessageContaining("but found");
    }

    @Test
    public void doesNotHaveBeanOfTypeWithLimitedScopeWhenInParentShouldPass() {
        this.parent.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean(Foo.class, ApplicationContextAssert.Scope.NO_ANCESTORS);
    }

    @Test
    public void doesNotHaveBeanOfNameWhenHasNoBeanOfTypeShouldPass() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean("foo");
    }

    @Test
    public void doesNotHaveBeanOfNameWhenHasBeanOfTypeShouldFail() {
        this.context.registerSingleton("foo", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).doesNotHaveBean("foo")).withMessageContaining("but found");
    }

    @Test
    public void doesNotHaveBeanOfNameWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).doesNotHaveBean("foo")).withMessageContaining("not to have any beans of name").withMessageContaining("failed to start");
    }

    @Test
    public void getBeanNamesWhenHasNamesShouldReturnNamesAssert() {
        this.context.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeanNames(Foo.class).containsOnly((Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void getBeanNamesWhenHasNoNamesShouldReturnEmptyAssert() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeanNames(Foo.class).isEmpty();
    }

    @Test
    public void getBeanNamesWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).doesNotHaveBean("foo")).withMessageContaining("not to have any beans of name").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void getBeanOfTypeWhenHasBeanShouldReturnBeanAssert() {
        this.context.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class).isNotNull();
    }

    @Test
    public void getBeanOfTypeWhenHasNoBeanShouldReturnNullAssert() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class).isNull();
    }

    @Test
    public void getBeanOfTypeWhenHasMultipleBeansShouldFail() {
        this.context.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class)).withMessageContaining("but found");
    }

    @Test
    public void getBeanOfTypeWhenHasPrimaryBeanShouldReturnPrimary() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext(new Class[]{PrimaryFooConfig.class});
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)context))).getBean(Foo.class).isInstanceOf(Bar.class);
        context.close();
    }

    @Test
    public void getBeanOfTypeWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getBean(Foo.class)).withMessageContaining("to contain bean of type").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void getBeanOfTypeWhenInParentShouldReturnBeanAssert() {
        this.parent.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class).isNotNull();
    }

    @Test
    public void getBeanOfTypeWhenInParentWithLimitedScopeShouldReturnNullAssert() {
        this.parent.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class, ApplicationContextAssert.Scope.NO_ANCESTORS).isNull();
    }

    @Test
    public void getBeanOfTypeWhenHasMultipleBeansIncludingParentShouldFail() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class)).withMessageContaining("but found");
    }

    @Test
    public void getBeanOfTypeWithLimitedScopeWhenHasMultipleBeansIncludingParentShouldReturnBeanAssert() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean(Foo.class, ApplicationContextAssert.Scope.NO_ANCESTORS).isNotNull();
    }

    @Test
    public void getBeanOfNameWhenHasBeanShouldReturnBeanAssert() {
        this.context.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean("foo").isNotNull();
    }

    @Test
    public void getBeanOfNameWhenHasNoBeanOfNameShouldReturnNullAssert() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean("foo").isNull();
    }

    @Test
    public void getBeanOfNameWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getBean("foo")).withMessageContaining("to contain a bean of name").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void getBeanOfNameAndTypeWhenHasBeanShouldReturnBeanAssert() {
        this.context.registerSingleton("foo", Foo.class);
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean("foo", Foo.class).isNotNull();
    }

    @Test
    public void getBeanOfNameAndTypeWhenHasNoBeanOfNameShouldReturnNullAssert() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean("foo", Foo.class).isNull();
    }

    @Test
    public void getBeanOfNameAndTypeWhenHasNoBeanOfNameButDifferentTypeShouldFail() {
        this.context.registerSingleton("foo", Foo.class);
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBean("foo", String.class)).withMessageContaining("of type");
    }

    @Test
    public void getBeanOfNameAndTypeWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getBean("foo", Foo.class)).withMessageContaining("to contain a bean of name").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void getBeansWhenHasBeansShouldReturnMapAssert() {
        this.context.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((MapAssert)((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeans(Foo.class).hasSize(2)).containsKeys((Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void getBeansWhenHasNoBeansShouldReturnEmptyMapAssert() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeans(Foo.class).isEmpty();
    }

    @Test
    public void getBeansWhenFailedToStartShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getBeans(Foo.class)).withMessageContaining("to get beans of type").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void getBeansShouldIncludeBeansFromParentScope() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((MapAssert)((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeans(Foo.class).hasSize(2)).containsKeys((Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void getBeansWithLimitedScopeShouldNotIncludeBeansFromParentScope() {
        this.parent.registerSingleton("foo", Foo.class);
        this.context.registerSingleton("bar", Foo.class);
        ((MapAssert)((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getBeans(Foo.class, ApplicationContextAssert.Scope.NO_ANCESTORS).hasSize(1)).containsKeys((Object[])new String[]{"bar"});
    }

    @Test
    public void getFailureWhenFailedShouldReturnFailure() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).getFailure().isSameAs((Object)this.failure);
    }

    @Test
    public void getFailureWhenDidNotFailShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).getFailure()).withMessageContaining("context started");
    }

    @Test
    public void hasFailedWhenFailedShouldPass() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).hasFailed();
    }

    @Test
    public void hasFailedWhenNotFailedShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasFailed()).withMessageContaining("to have failed");
    }

    @Test
    public void hasNotFailedWhenFailedShouldFail() {
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert(this.failure))).hasNotFailed()).withMessageContaining("to have not failed").withMessageContaining(String.format("but context failed to start:%n java.lang.RuntimeException", new Object[0]));
    }

    @Test
    public void hasNotFailedWhenNotFailedShouldPass() {
        ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)this.getAssert((ConfigurableApplicationContext)this.context))).hasNotFailed();
    }

    private AssertableApplicationContext getAssert(ConfigurableApplicationContext applicationContext) {
        return AssertableApplicationContext.get(() -> applicationContext);
    }

    private AssertableApplicationContext getAssert(RuntimeException failure) {
        return AssertableApplicationContext.get(() -> {
            throw failure;
        });
    }

    @Configuration
    static class PrimaryFooConfig {
        PrimaryFooConfig() {
        }

        @Bean
        public Foo foo() {
            return new Foo();
        }

        @Bean
        @Primary
        public Bar bar() {
            return new Bar();
        }
    }

    private static class Bar
    extends Foo {
        private Bar() {
        }
    }

    private static class Foo {
        private Foo() {
        }
    }
}

