/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.FilteredClassLoader;
import org.springframework.boot.test.context.assertj.ApplicationContextAssert;
import org.springframework.boot.test.context.assertj.ApplicationContextAssertProvider;
import org.springframework.boot.test.context.runner.AbstractApplicationContextRunner;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;

public abstract class AbstractApplicationContextRunnerTests<T extends AbstractApplicationContextRunner<T, C, A>, C extends ConfigurableApplicationContext, A extends ApplicationContextAssertProvider<C>> {
    @Test
    public void runWithInitializerShouldInitialize() {
        AtomicBoolean called = new AtomicBoolean();
        this.get().withInitializer(context -> called.set(true)).run(context -> {});
        Assertions.assertThat((AtomicBoolean)called).isTrue();
    }

    @Test
    public void runWithSystemPropertiesShouldSetAndRemoveProperties() {
        String key = "test." + UUID.randomUUID();
        Assertions.assertThat((boolean)System.getProperties().containsKey(key)).isFalse();
        this.get().withSystemProperties(new String[]{key + "=value"}).run(context -> {
            MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat((Map)System.getProperties()).containsEntry((Object)key, (Object)"value");
        });
        Assertions.assertThat((boolean)System.getProperties().containsKey(key)).isFalse();
    }

    @Test
    public void runWithSystemPropertiesWhenContextFailsShouldRemoveProperties() {
        String key = "test." + UUID.randomUUID();
        Assertions.assertThat((boolean)System.getProperties().containsKey(key)).isFalse();
        this.get().withSystemProperties(new String[]{key + "=value"}).withUserConfiguration(new Class[]{FailingConfig.class}).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasFailed());
        Assertions.assertThat((boolean)System.getProperties().containsKey(key)).isFalse();
    }

    @Test
    public void runWithSystemPropertiesShouldRestoreOriginalProperties() {
        String key = "test." + UUID.randomUUID();
        System.setProperty(key, "value");
        try {
            Assertions.assertThat((String)System.getProperties().getProperty(key)).isEqualTo((Object)"value");
            this.get().withSystemProperties(new String[]{key + "=newValue"}).run(context -> {
                MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat((Map)System.getProperties()).containsEntry((Object)key, (Object)"newValue");
            });
            Assertions.assertThat((String)System.getProperties().getProperty(key)).isEqualTo((Object)"value");
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void runWithSystemPropertiesWhenValueIsNullShouldRemoveProperty() {
        String key = "test." + UUID.randomUUID();
        System.setProperty(key, "value");
        try {
            Assertions.assertThat((String)System.getProperties().getProperty(key)).isEqualTo((Object)"value");
            this.get().withSystemProperties(new String[]{key + "="}).run(context -> {
                MapAssert cfr_ignored_0 = (MapAssert)Assertions.assertThat((Map)System.getProperties()).doesNotContainKey((Object)key);
            });
            Assertions.assertThat((String)System.getProperties().getProperty(key)).isEqualTo((Object)"value");
        }
        finally {
            System.clearProperty(key);
        }
    }

    @Test
    public void runWithMultiplePropertyValuesShouldAllAllValues() {
        this.get().withPropertyValues(new String[]{"test.foo=1"}).withPropertyValues(new String[]{"test.bar=2"}).run(context -> {
            Environment environment = context.getEnvironment();
            Assertions.assertThat((String)environment.getProperty("test.foo")).isEqualTo((Object)"1");
            Assertions.assertThat((String)environment.getProperty("test.bar")).isEqualTo((Object)"2");
        });
    }

    @Test
    public void runWithPropertyValuesWhenHasExistingShouldReplaceValue() {
        this.get().withPropertyValues(new String[]{"test.foo=1"}).withPropertyValues(new String[]{"test.foo=2"}).run(context -> {
            Environment environment = context.getEnvironment();
            Assertions.assertThat((String)environment.getProperty("test.foo")).isEqualTo((Object)"2");
        });
    }

    @Test
    public void runWithConfigurationsShouldRegisterConfigurations() {
        this.get().withUserConfiguration(new Class[]{FooConfig.class}).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasBean("foo"));
    }

    @Test
    public void runWithMultipleConfigurationsShouldRegisterAllConfigurations() {
        this.get().withUserConfiguration(new Class[]{FooConfig.class}).withConfiguration((Configurations)UserConfigurations.of((Class[])new Class[]{BarConfig.class})).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasBean("foo").hasBean("bar"));
    }

    @Test
    public void runWithFailedContextShouldReturnFailedAssertableContext() {
        this.get().withUserConfiguration(new Class[]{FailingConfig.class}).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasFailed());
    }

    @Test
    public void runWithClassLoaderShouldSetClassLoaderOnContext() {
        this.get().withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{Gson.class.getPackage().getName()})).run(context -> {
            try {
                ClassUtils.forName((String)Gson.class.getName(), (ClassLoader)context.getClassLoader());
                Assert.fail((String)"Should have thrown a ClassNotFoundException");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        });
    }

    @Test
    public void runWithClassLoaderShouldSetClassLoaderOnConditionContext() {
        this.get().withClassLoader((ClassLoader)new FilteredClassLoader(new String[]{Gson.class.getPackage().getName()})).withUserConfiguration(new Class[]{ConditionalConfig.class}).run(context -> ((ApplicationContextAssert)Assertions.assertThat((AssertProvider)context)).hasSingleBean(ConditionalConfig.class));
    }

    @Test
    public void thrownRuleWorksWithCheckedException() {
        this.get().run(context -> Assertions.assertThatIOException().isThrownBy(() -> AbstractApplicationContextRunnerTests.throwCheckedException("Expected message")).withMessageContaining("Expected message"));
    }

    protected abstract T get();

    private static void throwCheckedException(String message) throws IOException {
        throw new IOException(message);
    }

    static class FilteredClassLoaderCondition
    implements Condition {
        FilteredClassLoaderCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return context.getClassLoader() instanceof FilteredClassLoader;
        }
    }

    @Configuration
    @Conditional(value={FilteredClassLoaderCondition.class})
    static class ConditionalConfig {
        ConditionalConfig() {
        }
    }

    @Configuration
    static class BarConfig {
        BarConfig() {
        }

        @Bean
        public String bar() {
            return "bar";
        }
    }

    @Configuration
    static class FooConfig {
        FooConfig() {
        }

        @Bean
        public String foo() {
            return "foo";
        }
    }

    @Configuration
    static class FailingConfig {
        FailingConfig() {
        }

        @Bean
        public String foo() {
            throw new IllegalStateException("Failed");
        }
    }
}

