/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.comparator.DefaultComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class JsonContentAssertTests {
    private static final String SOURCE = JsonContentAssertTests.loadJson("source.json");
    private static final String LENIENT_SAME = JsonContentAssertTests.loadJson("lenient-same.json");
    private static final String DIFFERENT = JsonContentAssertTests.loadJson("different.json");
    private static final String TYPES = JsonContentAssertTests.loadJson("types.json");
    private static final String SIMPSONS = JsonContentAssertTests.loadJson("simpsons.json");
    private static JSONComparator COMPARATOR = new DefaultComparator(JSONCompareMode.LENIENT);
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void isEqualToWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)LENIENT_SAME);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenNullActualShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isEqualTo((Object)SOURCE);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenStringIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)DIFFERENT);
    }

    @Test
    public void isEqualToWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)"lenient-same.json");
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenResourcePathIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)"different.json");
    }

    @Test
    public void isEqualToWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)LENIENT_SAME.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenBytesAreNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)DIFFERENT.getBytes());
    }

    @Test
    public void isEqualToWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createFile(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenFileIsNotMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createFile(DIFFERENT));
    }

    @Test
    public void isEqualToWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createInputStream(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenInputStreamIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createInputStream(DIFFERENT));
    }

    @Test
    public void isEqualToWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createResource(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenResourceIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualTo((Object)this.createResource(DIFFERENT));
    }

    @Test
    public void isEqualToJsonWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenNullActualShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isEqualToJson((CharSequence)SOURCE);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenStringIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT);
    }

    @Test
    public void isEqualToJsonWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json");
    }

    @Test
    public void isEqualToJsonWhenResourcePathAndClassIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass());
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathAndClassIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass());
    }

    @Test
    public void isEqualToJsonWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenBytesAreNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes());
    }

    @Test
    public void isEqualToJsonWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenFileIsNotMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT));
    }

    @Test
    public void isEqualToJsonWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenInputStreamIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT));
    }

    @Test
    public void isEqualToJsonWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourceIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT));
    }

    @Test
    public void isStrictlyEqualToJsonWhenStringIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)SOURCE);
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenStringIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test
    public void isStrictlyEqualToJsonWhenResourcePathIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)"source.json");
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenResourcePathIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test
    public void isStrictlyEqualToJsonWhenResourcePathAndClassIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson("source.json", this.getClass());
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenResourcePathAndClassIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson("lenient-same.json", this.getClass());
    }

    @Test
    public void isStrictlyEqualToJsonWhenBytesAreMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(SOURCE.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenBytesAreNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test
    public void isStrictlyEqualToJsonWhenFileIsMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createFile(SOURCE));
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenFileIsNotMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test
    public void isStrictlyEqualToJsonWhenInputStreamIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createInputStream(SOURCE));
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenInputStreamIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test
    public void isStrictlyEqualToJsonWhenResourceIsMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createResource(SOURCE));
    }

    @Test(expected=AssertionError.class)
    public void isStrictlyEqualToJsonWhenResourceIsNotMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isStrictlyEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test
    public void isEqualToJsonWhenStringIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME, JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenStringIsNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT, JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenResourcePathIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json", JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathIsNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json", JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenResourcePathAndClassIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathAndClassIsNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenBytesAreMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenBytesAreNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenFileIsMatchingAndLenientShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenFileIsNotMatchingAndLenientShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenInputStreamIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenInputStreamIsNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenResourceIsMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourceIsNotMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test
    public void isEqualToJsonWhenStringIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)LENIENT_SAME, COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenStringIsNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)DIFFERENT, COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenResourcePathIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"lenient-same.json", COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathIsNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson((CharSequence)"different.json", COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenResourcePathAndClassAreMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("lenient-same.json", this.getClass(), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourcePathAndClassAreNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson("different.json", this.getClass(), COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenBytesAreMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(LENIENT_SAME.getBytes(), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenBytesAreNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(DIFFERENT.getBytes(), COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenFileIsMatchingAndComparatorShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(LENIENT_SAME), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenFileIsNotMatchingAndComparatorShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createFile(DIFFERENT), COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenInputStreamIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(LENIENT_SAME), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenInputStreamIsNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createInputStream(DIFFERENT), COMPARATOR);
    }

    @Test
    public void isEqualToJsonWhenResourceIsMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(LENIENT_SAME), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToJsonWhenResourceIsNotMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isEqualToJson(this.createResource(DIFFERENT), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenStringIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)LENIENT_SAME);
    }

    @Test
    public void isNotEqualToWhenNullActualShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNotEqualTo((Object)SOURCE);
    }

    @Test
    public void isNotEqualToWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)DIFFERENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenResourcePathIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)"lenient-same.json");
    }

    @Test
    public void isNotEqualToWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)"different.json");
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenBytesAreMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)LENIENT_SAME.getBytes());
    }

    @Test
    public void isNotEqualToWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)DIFFERENT.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenFileIsMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createFile(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createFile(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenInputStreamIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createInputStream(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createInputStream(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToWhenResourceIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createResource(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualTo((Object)this.createResource(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenStringIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test
    public void isNotEqualToJsonWhenNullActualShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNotEqualToJson((CharSequence)SOURCE);
    }

    @Test
    public void isNotEqualToJsonWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json");
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathAndClassAreMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass());
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass());
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenBytesAreMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test
    public void isNotEqualToJsonWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenFileIsMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToJsonWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenInputStreamIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToJsonWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourceIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test
    public void isNotEqualToJsonWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT));
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenStringIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)SOURCE);
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenStringIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)LENIENT_SAME);
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenResourcePathIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)"source.json");
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenResourcePathIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson((CharSequence)"lenient-same.json");
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenResourcePathAndClassAreMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson("source.json", this.getClass());
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenResourcePathAndClassAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson("lenient-same.json", this.getClass());
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenBytesAreMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(SOURCE.getBytes());
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenBytesAreNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(LENIENT_SAME.getBytes());
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenFileIsMatchingShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createFile(SOURCE));
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenFileIsNotMatchingShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createFile(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenInputStreamIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createInputStream(SOURCE));
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenInputStreamIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createInputStream(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isNotStrictlyEqualToJsonWhenResourceIsMatchingShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createResource(SOURCE));
    }

    @Test
    public void isNotStrictlyEqualToJsonWhenResourceIsNotMatchingShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotStrictlyEqualToJson(this.createResource(LENIENT_SAME));
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenStringIsMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME, JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenStringIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT, JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathIsMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json", JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json", JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathAndClassAreMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass(), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenBytesAreMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenBytesAreNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes(), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenFileIsMatchingAndLenientShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenFileIsNotMatchingAndLenientShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenInputStreamIsMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenInputStreamIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourceIsMatchingAndLenientShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME), JSONCompareMode.LENIENT);
    }

    @Test
    public void isNotEqualToJsonWhenResourceIsNotMatchingAndLenientShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT), JSONCompareMode.LENIENT);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenStringIsMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)LENIENT_SAME, COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenStringIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)DIFFERENT, COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathIsMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"lenient-same.json", COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson((CharSequence)"different.json", COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourcePathAndClassAreMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("lenient-same.json", this.getClass(), COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenResourcePathAndClassAreNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson("different.json", this.getClass(), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenBytesAreMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(LENIENT_SAME.getBytes(), COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenBytesAreNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(DIFFERENT.getBytes(), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenFileIsMatchingAndComparatorShouldFail() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(LENIENT_SAME), COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenFileIsNotMatchingAndComparatorShouldPass() throws Exception {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createFile(DIFFERENT), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenInputStreamIsMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(LENIENT_SAME), COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenInputStreamIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createInputStream(DIFFERENT), COMPARATOR);
    }

    @Test(expected=AssertionError.class)
    public void isNotEqualToJsonWhenResourceIsMatchingAndComparatorShouldFail() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(LENIENT_SAME), COMPARATOR);
    }

    @Test
    public void isNotEqualToJsonWhenResourceIsNotMatchingAndComparatorShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SOURCE))).isNotEqualToJson(this.createResource(DIFFERENT), COMPARATOR);
    }

    @Test
    public void hasJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    public void hasJsonPathValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    public void hasJsonPathValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    public void hasJsonPathValueForIndefinitePathWithResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Bart')]", new Object[0]);
    }

    @Test
    public void hasJsonPathValueForIndefinitePathWithEmptyResults() {
        String expression = "$.familyMembers[?(@.name == 'Dilbert')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("No value at JSON path \"" + expression + "\"");
    }

    @Test
    public void doesNotHaveJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)"$.bogus", new Object[0]);
    }

    @Test
    public void doesNotHaveJsonPathValueForAnEmptyArray() {
        String expression = "$.emptyArray";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    public void doesNotHaveJsonPathValueForAnEmptyMap() {
        String expression = "$.emptyMap";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: {}");
    }

    @Test
    public void doesNotHaveJsonPathValueForIndefinitePathWithResults() {
        String expression = "$.familyMembers[?(@.name == 'Bart')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected no value at JSON path \"" + expression + "\" but found: [{\"name\":\"Bart\"}]");
    }

    @Test
    public void doesNotHaveJsonPathValueForIndefinitePathWithEmptyResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Dilbert')]", new Object[0]);
    }

    @Test
    public void hasEmptyJsonPathValueForAnEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyString", new Object[0]);
    }

    @Test
    public void hasEmptyJsonPathValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    public void hasEmptyJsonPathValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    public void hasEmptyJsonPathValueForIndefinitePathWithEmptyResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasEmptyJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Dilbert')]", new Object[0]);
    }

    @Test
    public void hasEmptyJsonPathValueForIndefinitePathWithResults() {
        String expression = "$.familyMembers[?(@.name == 'Bart')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).hasEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an empty value at JSON path \"" + expression + "\" but found: [{\"name\":\"Bart\"}]");
    }

    @Test
    public void hasEmptyJsonPathValueForWhitespace() {
        String expression = "$.whitespace";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an empty value at JSON path \"" + expression + "\" but found: '    '");
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForNumber() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.num", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForBoolean() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.bool", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.arr", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.colorMap", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForIndefinitePathWithResults() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveEmptyJsonPathValue((CharSequence)"$.familyMembers[?(@.name == 'Bart')]", new Object[0]);
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForIndefinitePathWithEmptyResults() {
        String expression = "$.familyMembers[?(@.name == 'Dilbert')]";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(SIMPSONS))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForAnEmptyString() {
        String expression = "$.emptyString";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: ''");
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForForAnEmptyArray() {
        String expression = "$.emptyArray";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: []");
    }

    @Test
    public void doesNotHaveEmptyJsonPathValueForAnEmptyMap() {
        String expression = "$.emptyMap";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).doesNotHaveEmptyJsonPathValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a non-empty value at JSON path \"" + expression + "\" but found: {}");
    }

    @Test
    public void hasJsonPathStringValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)"$.str", new Object[0]);
    }

    @Test
    public void hasJsonPathStringValueForAnEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)"$.emptyString", new Object[0]);
    }

    @Test
    public void hasJsonPathStringValueForNonString() {
        String expression = "$.bool";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathStringValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a string at JSON path \"" + expression + "\" but found: true");
    }

    @Test
    public void hasJsonPathNumberValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathNumberValue((CharSequence)"$.num", new Object[0]);
    }

    @Test
    public void hasJsonPathNumberValueForNonNumber() {
        String expression = "$.bool";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathNumberValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a number at JSON path \"" + expression + "\" but found: true");
    }

    @Test
    public void hasJsonPathBooleanValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathBooleanValue((CharSequence)"$.bool", new Object[0]);
    }

    @Test
    public void hasJsonPathBooleanValueForNonBoolean() {
        String expression = "$.num";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathBooleanValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a boolean at JSON path \"" + expression + "\" but found: 5");
    }

    @Test
    public void hasJsonPathArrayValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)"$.arr", new Object[0]);
    }

    @Test
    public void hasJsonPathArrayValueForAnEmptyArray() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)"$.emptyArray", new Object[0]);
    }

    @Test
    public void hasJsonPathArrayValueForNonArray() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathArrayValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an array at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void hasJsonPathMapValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)"$.colorMap", new Object[0]);
    }

    @Test
    public void hasJsonPathMapValueForAnEmptyMap() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)"$.emptyMap", new Object[0]);
    }

    @Test
    public void hasJsonPathMapValueForNonMap() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).hasJsonPathMapValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a map at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void extractingJsonPathValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathValue((CharSequence)"@.str", new Object[0]).isEqualTo((Object)"foo");
    }

    @Test
    public void extractingJsonPathValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathStringValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.str", new Object[0]).isEqualTo((Object)"foo");
    }

    @Test
    public void extractingJsonPathStringValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathStringValueForEmptyString() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)"@.emptyString", new Object[0]).isEmpty();
    }

    @Test
    public void extractingJsonPathStringValueForWrongType() {
        String expression = "$.num";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathStringValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a string at JSON path \"" + expression + "\" but found: 5");
    }

    @Test
    public void extractingJsonPathNumberValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)"@.num", new Object[0]).isEqualTo((Object)5);
    }

    @Test
    public void extractingJsonPathNumberValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathNumberValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathNumberValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a number at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void extractingJsonPathBooleanValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)"@.bool", new Object[0]).isTrue();
    }

    @Test
    public void extractingJsonPathBooleanValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathBooleanValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathBooleanValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a boolean at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void extractingJsonPathArrayValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.arr", new Object[0]).containsExactly(new Object[]{42});
    }

    @Test
    public void extractingJsonPathArrayValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathArrayValueForEmpty() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)"@.emptyArray", new Object[0]).isEmpty();
    }

    @Test
    public void extractingJsonPathArrayValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathArrayValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected an array at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void extractingJsonPathMapValue() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.colorMap", new Object[0]).contains(new Map.Entry[]{Assertions.entry((Object)"red", (Object)"rojo")});
    }

    @Test
    public void extractingJsonPathMapValueForMissing() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.bogus", new Object[0]).isNull();
    }

    @Test
    public void extractingJsonPathMapValueForEmpty() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)"@.emptyMap", new Object[0]).isEmpty();
    }

    @Test
    public void extractingJsonPathMapValueForWrongType() {
        String expression = "$.str";
        Assertions.assertThatExceptionOfType(AssertionError.class).isThrownBy(() -> ((JsonContentAssert)Assertions.assertThat(this.forJson(TYPES))).extractingJsonPathMapValue((CharSequence)expression, new Object[0])).withMessageContaining("Expected a map at JSON path \"" + expression + "\" but found: 'foo'");
    }

    @Test
    public void isNullWhenActualIsNullShouldPass() {
        ((JsonContentAssert)Assertions.assertThat(this.forJson(null))).isNull();
    }

    private File createFile(String content) throws IOException {
        File file = this.tempFolder.newFile("file.json");
        FileCopyUtils.copy((byte[])content.getBytes(), (File)file);
        return file;
    }

    private InputStream createInputStream(String content) {
        return new ByteArrayInputStream(content.getBytes());
    }

    private Resource createResource(String content) {
        return new ByteArrayResource(content.getBytes());
    }

    private static String loadJson(String path) {
        try {
            ClassPathResource resource = new ClassPathResource(path, JsonContentAssertTests.class);
            return new String(FileCopyUtils.copyToByteArray((InputStream)resource.getInputStream()));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private AssertProvider<JsonContentAssert> forJson(String json) {
        return () -> new JsonContentAssert(JsonContentAssertTests.class, (CharSequence)json);
    }
}

