/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.JsonContent;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.ResolvableType;

public class JsonContentTests {
    private static final String JSON = "{\"name\":\"spring\", \"age\":100}";
    private static final ResolvableType TYPE = ResolvableType.forClass(ExampleObject.class);

    @Test
    public void createWhenResourceLoadClassIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new JsonContent(null, TYPE, JSON)).withMessageContaining("ResourceLoadClass must not be null");
    }

    @Test
    public void createWhenJsonIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new JsonContent(this.getClass(), TYPE, null)).withMessageContaining("JSON must not be null");
    }

    @Test
    public void createWhenTypeIsNullShouldCreateContent() {
        JsonContent content = new JsonContent(this.getClass(), null, JSON);
        ((JsonContentAssert)Assertions.assertThat((AssertProvider)content)).isNotNull();
    }

    @Test
    public void assertThatShouldReturnJsonContentAssert() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON);
        Assertions.assertThat((Object)content.assertThat()).isInstanceOf(JsonContentAssert.class);
    }

    @Test
    public void getJsonShouldReturnJson() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON);
        Assertions.assertThat((String)content.getJson()).isEqualTo((Object)JSON);
    }

    @Test
    public void toStringWhenHasTypeShouldReturnString() {
        JsonContent content = new JsonContent(this.getClass(), TYPE, JSON);
        Assertions.assertThat((String)content.toString()).isEqualTo((Object)("JsonContent {\"name\":\"spring\", \"age\":100} created from " + TYPE));
    }

    @Test
    public void toStringWhenHasNoTypeShouldReturnString() {
        JsonContent content = new JsonContent(this.getClass(), null, JSON);
        Assertions.assertThat((String)content.toString()).isEqualTo((Object)"JsonContent {\"name\":\"spring\", \"age\":100}");
    }
}

