/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.boot.test.json.ExampleObject;
import org.springframework.boot.test.json.ObjectContentAssert;

public class ObjectContentAssertTests {
    private static final ExampleObject SOURCE = new ExampleObject();
    private static final ExampleObject DIFFERENT = new ExampleObject();

    @Test
    public void isEqualToWhenObjectsAreEqualShouldPass() {
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).isEqualTo((Object)SOURCE);
    }

    @Test(expected=AssertionError.class)
    public void isEqualToWhenObjectsAreDifferentShouldFail() {
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).isEqualTo((Object)DIFFERENT);
    }

    @Test
    public void asArrayForArrayShouldReturnObjectArrayAssert() {
        ExampleObject[] source = new ExampleObject[]{SOURCE};
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(source))).asArray().containsExactly(new Object[]{SOURCE});
    }

    @Test(expected=AssertionError.class)
    public void asArrayForNonArrayShouldFail() {
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).asArray();
    }

    @Test
    public void asMapForMapShouldReturnMapAssert() {
        Map<String, ExampleObject> source = Collections.singletonMap("a", SOURCE);
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(source))).asMap().containsEntry((Object)"a", (Object)SOURCE);
    }

    @Test(expected=AssertionError.class)
    public void asMapForNonMapShouldFail() {
        ((ObjectContentAssert)Assertions.assertThat(this.forObject(SOURCE))).asMap();
    }

    private AssertProvider<ObjectContentAssert<Object>> forObject(Object source) {
        return () -> new ObjectContentAssert(source);
    }

    static {
        DIFFERENT.setAge(123);
    }
}

