/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.Answers;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.mock.mockito.Definition;
import org.springframework.boot.test.mock.mockito.DefinitionsParser;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.MockBeans;
import org.springframework.boot.test.mock.mockito.MockDefinition;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.SpyBeans;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.boot.test.mock.mockito.example.ExampleExtraInterface;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.RealExampleService;
import org.springframework.util.ReflectionUtils;

public class DefinitionsParserTests {
    private DefinitionsParser parser = new DefinitionsParser();

    @Test
    public void parseSingleMockBean() {
        this.parser.parse(SingleMockBean.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        Assertions.assertThat((Class)this.getMockDefinition(0).getTypeToMock().resolve()).isEqualTo(ExampleService.class);
    }

    @Test
    public void parseRepeatMockBean() {
        this.parser.parse(RepeatMockBean.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        Assertions.assertThat((Class)this.getMockDefinition(0).getTypeToMock().resolve()).isEqualTo(ExampleService.class);
        Assertions.assertThat((Class)this.getMockDefinition(1).getTypeToMock().resolve()).isEqualTo(ExampleServiceCaller.class);
    }

    @Test
    public void parseMockBeanAttributes() {
        this.parser.parse(MockBeanAttributes.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        MockDefinition definition = this.getMockDefinition(0);
        Assertions.assertThat((String)definition.getName()).isEqualTo((Object)"Name");
        Assertions.assertThat((Class)definition.getTypeToMock().resolve()).isEqualTo(ExampleService.class);
        Assertions.assertThat((Iterable)definition.getExtraInterfaces()).containsExactly((Object[])new Class[]{ExampleExtraInterface.class});
        Assertions.assertThat((Comparable)definition.getAnswer()).isEqualTo((Object)Answers.RETURNS_SMART_NULLS);
        Assertions.assertThat((boolean)definition.isSerializable()).isTrue();
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.NONE);
        Assertions.assertThat((Object)definition.getQualifier()).isNull();
    }

    @Test
    public void parseMockBeanOnClassAndField() {
        this.parser.parse(MockBeanOnClassAndField.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        MockDefinition classDefinition = this.getMockDefinition(0);
        Assertions.assertThat((Class)classDefinition.getTypeToMock().resolve()).isEqualTo(ExampleService.class);
        Assertions.assertThat((Object)classDefinition.getQualifier()).isNull();
        MockDefinition fieldDefinition = this.getMockDefinition(1);
        Assertions.assertThat((Class)fieldDefinition.getTypeToMock().resolve()).isEqualTo(ExampleServiceCaller.class);
        QualifierDefinition qualifier = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(MockBeanOnClassAndField.class, (String)"caller"));
        ((ObjectAssert)Assertions.assertThat((Object)fieldDefinition.getQualifier()).isNotNull()).isEqualTo((Object)qualifier);
    }

    @Test
    public void parseMockBeanInferClassToMock() {
        this.parser.parse(MockBeanInferClassToMock.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        Assertions.assertThat((Class)this.getMockDefinition(0).getTypeToMock().resolve()).isEqualTo(ExampleService.class);
    }

    @Test
    public void parseMockBeanMissingClassToMock() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.parser.parse(MockBeanMissingClassToMock.class)).withMessageContaining("Unable to deduce type to mock");
    }

    @Test
    public void parseMockBeanMultipleClasses() {
        this.parser.parse(MockBeanMultipleClasses.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        Assertions.assertThat((Class)this.getMockDefinition(0).getTypeToMock().resolve()).isEqualTo(ExampleService.class);
        Assertions.assertThat((Class)this.getMockDefinition(1).getTypeToMock().resolve()).isEqualTo(ExampleServiceCaller.class);
    }

    @Test
    public void parseMockBeanMultipleClassesWithName() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.parser.parse(MockBeanMultipleClassesWithName.class)).withMessageContaining("The name attribute can only be used when mocking a single class");
    }

    @Test
    public void parseSingleSpyBean() {
        this.parser.parse(SingleSpyBean.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        Assertions.assertThat((Class)this.getSpyDefinition(0).getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
    }

    @Test
    public void parseRepeatSpyBean() {
        this.parser.parse(RepeatSpyBean.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        Assertions.assertThat((Class)this.getSpyDefinition(0).getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
        Assertions.assertThat((Class)this.getSpyDefinition(1).getTypeToSpy().resolve()).isEqualTo(ExampleServiceCaller.class);
    }

    @Test
    public void parseSpyBeanAttributes() {
        this.parser.parse(SpyBeanAttributes.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        SpyDefinition definition = this.getSpyDefinition(0);
        Assertions.assertThat((String)definition.getName()).isEqualTo((Object)"Name");
        Assertions.assertThat((Class)definition.getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.NONE);
        Assertions.assertThat((Object)definition.getQualifier()).isNull();
    }

    @Test
    public void parseSpyBeanOnClassAndField() {
        this.parser.parse(SpyBeanOnClassAndField.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        SpyDefinition classDefinition = this.getSpyDefinition(0);
        Assertions.assertThat((Object)classDefinition.getQualifier()).isNull();
        Assertions.assertThat((Class)classDefinition.getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
        SpyDefinition fieldDefinition = this.getSpyDefinition(1);
        QualifierDefinition qualifier = QualifierDefinition.forElement((AnnotatedElement)ReflectionUtils.findField(SpyBeanOnClassAndField.class, (String)"caller"));
        ((ObjectAssert)Assertions.assertThat((Object)fieldDefinition.getQualifier()).isNotNull()).isEqualTo((Object)qualifier);
        Assertions.assertThat((Class)fieldDefinition.getTypeToSpy().resolve()).isEqualTo(ExampleServiceCaller.class);
    }

    @Test
    public void parseSpyBeanInferClassToMock() {
        this.parser.parse(SpyBeanInferClassToMock.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(1);
        Assertions.assertThat((Class)this.getSpyDefinition(0).getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
    }

    @Test
    public void parseSpyBeanMissingClassToMock() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.parser.parse(SpyBeanMissingClassToMock.class)).withMessageContaining("Unable to deduce type to spy");
    }

    @Test
    public void parseSpyBeanMultipleClasses() {
        this.parser.parse(SpyBeanMultipleClasses.class);
        Assertions.assertThat(this.getDefinitions()).hasSize(2);
        Assertions.assertThat((Class)this.getSpyDefinition(0).getTypeToSpy().resolve()).isEqualTo(RealExampleService.class);
        Assertions.assertThat((Class)this.getSpyDefinition(1).getTypeToSpy().resolve()).isEqualTo(ExampleServiceCaller.class);
    }

    @Test
    public void parseSpyBeanMultipleClassesWithName() {
        Assertions.assertThatIllegalStateException().isThrownBy(() -> this.parser.parse(SpyBeanMultipleClassesWithName.class)).withMessageContaining("The name attribute can only be used when spying a single class");
    }

    private MockDefinition getMockDefinition(int index) {
        return (MockDefinition)this.getDefinitions().get(index);
    }

    private SpyDefinition getSpyDefinition(int index) {
        return (SpyDefinition)this.getDefinitions().get(index);
    }

    private List<Definition> getDefinitions() {
        return new ArrayList<Definition>(this.parser.getDefinitions());
    }

    @SpyBean
    static class SpyBeanMissingClassToMock {
        SpyBeanMissingClassToMock() {
        }
    }

    static class SpyBeanInferClassToMock {
        @SpyBean
        private RealExampleService exampleService;

        SpyBeanInferClassToMock() {
        }
    }

    @SpyBean(name="name", classes={RealExampleService.class, ExampleServiceCaller.class})
    static class SpyBeanMultipleClassesWithName {
        SpyBeanMultipleClassesWithName() {
        }
    }

    @SpyBean(value={RealExampleService.class, ExampleServiceCaller.class})
    static class SpyBeanMultipleClasses {
        SpyBeanMultipleClasses() {
        }
    }

    @SpyBean(value={RealExampleService.class})
    static class SpyBeanOnClassAndField {
        @SpyBean(value={ExampleServiceCaller.class})
        @Qualifier(value="test")
        private Object caller;

        SpyBeanOnClassAndField() {
        }
    }

    @SpyBean(name="Name", classes={RealExampleService.class}, reset=MockReset.NONE)
    static class SpyBeanAttributes {
        SpyBeanAttributes() {
        }
    }

    @SpyBeans(value={@SpyBean(value={RealExampleService.class}), @SpyBean(value={ExampleServiceCaller.class})})
    static class RepeatSpyBean {
        RepeatSpyBean() {
        }
    }

    @SpyBean(value={RealExampleService.class})
    static class SingleSpyBean {
        SingleSpyBean() {
        }
    }

    @MockBean
    static class MockBeanMissingClassToMock {
        MockBeanMissingClassToMock() {
        }
    }

    static class MockBeanInferClassToMock {
        @MockBean
        private ExampleService exampleService;

        MockBeanInferClassToMock() {
        }
    }

    @MockBean(name="name", classes={ExampleService.class, ExampleServiceCaller.class})
    static class MockBeanMultipleClassesWithName {
        MockBeanMultipleClassesWithName() {
        }
    }

    @MockBean(value={ExampleService.class, ExampleServiceCaller.class})
    static class MockBeanMultipleClasses {
        MockBeanMultipleClasses() {
        }
    }

    @MockBean(value={ExampleService.class})
    static class MockBeanOnClassAndField {
        @MockBean(value={ExampleServiceCaller.class})
        @Qualifier(value="test")
        private Object caller;

        MockBeanOnClassAndField() {
        }
    }

    @MockBean(name="Name", classes={ExampleService.class}, extraInterfaces={ExampleExtraInterface.class}, answer=Answers.RETURNS_SMART_NULLS, serializable=true, reset=MockReset.NONE)
    static class MockBeanAttributes {
        MockBeanAttributes() {
        }
    }

    @MockBeans(value={@MockBean(value={ExampleService.class}), @MockBean(value={ExampleServiceCaller.class})})
    static class RepeatMockBean {
        RepeatMockBean() {
        }
    }

    @MockBean(value={ExampleService.class})
    static class SingleMockBean {
        SingleMockBean() {
        }
    }
}

