/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextHierarchy;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextHierarchy(value={@ContextConfiguration(classes={ParentConfig.class}), @ContextConfiguration(classes={ChildConfig.class})})
public class MockBeanOnContextHierarchyIntegrationTests {
    @Autowired
    private ChildConfig childConfig;

    @Test
    public void testMocking() {
        ApplicationContext context = this.childConfig.getContext();
        ApplicationContext parentContext = context.getParent();
        Assertions.assertThat((Object[])parentContext.getBeanNamesForType(ExampleService.class)).hasSize(1);
        Assertions.assertThat((Object[])parentContext.getBeanNamesForType(ExampleServiceCaller.class)).hasSize(0);
        Assertions.assertThat((Object[])context.getBeanNamesForType(ExampleService.class)).hasSize(0);
        Assertions.assertThat((Object[])context.getBeanNamesForType(ExampleServiceCaller.class)).hasSize(1);
        Assertions.assertThat((Object)context.getBean(ExampleService.class)).isNotNull();
        Assertions.assertThat((Object)context.getBean(ExampleServiceCaller.class)).isNotNull();
    }

    @Configuration
    @MockBean(value={ExampleServiceCaller.class})
    static class ChildConfig
    implements ApplicationContextAware {
        private ApplicationContext context;

        ChildConfig() {
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.context = applicationContext;
        }

        public ApplicationContext getContext() {
            return this.context;
        }
    }

    @Configuration
    @MockBean(value={ExampleService.class})
    static class ParentConfig {
        ParentConfig() {
        }
    }
}

