/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class MockBeanWithAopProxyTests {
    @MockBean
    private DateService dateService;

    @Test
    public void verifyShouldUseProxyTarget() {
        BDDMockito.given((Object)this.dateService.getDate(false)).willReturn((Object)1L);
        Long d1 = this.dateService.getDate(false);
        Assertions.assertThat((Long)d1).isEqualTo(1L);
        BDDMockito.given((Object)this.dateService.getDate(false)).willReturn((Object)2L);
        Long d2 = this.dateService.getDate(false);
        Assertions.assertThat((Long)d2).isEqualTo(2L);
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)2))).getDate(false);
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)2))).getDate(ArgumentMatchers.eq((boolean)false));
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)2))).getDate(ArgumentMatchers.anyBoolean());
    }

    @Service
    static class DateService {
        DateService() {
        }

        @Cacheable(cacheNames={"test"})
        public Long getDate(boolean argument) {
            return System.nanoTime();
        }
    }

    @Configuration
    @EnableCaching(proxyTargetClass=true)
    @Import(value={DateService.class})
    static class Config {
        Config() {
        }

        @Bean
        public CacheResolver cacheResolver(CacheManager cacheManager) {
            SimpleCacheResolver resolver = new SimpleCacheResolver();
            resolver.setCacheManager(cacheManager);
            return resolver;
        }

        @Bean
        public ConcurrentMapCacheManager cacheManager() {
            ConcurrentMapCacheManager cacheManager = new ConcurrentMapCacheManager();
            cacheManager.setCacheNames(Arrays.asList("test"));
            return cacheManager;
        }
    }
}

