/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class MockBeanWithAsyncInterfaceMethodIntegrationTests {
    @MockBean
    private Transformer transformer;
    @Autowired
    private MyService service;

    @Test
    public void mockedMethodsAreNotAsync() {
        BDDMockito.given((Object)this.transformer.transform("foo")).willReturn((Object)"bar");
        Assertions.assertThat((String)this.service.transform("foo")).isEqualTo((Object)"bar");
    }

    @Configuration
    @EnableAsync
    static class MyConfiguration {
        MyConfiguration() {
        }

        @Bean
        public MyService myService(Transformer transformer) {
            return new MyService(transformer);
        }
    }

    private static class MyService {
        private final Transformer transformer;

        MyService(Transformer transformer) {
            this.transformer = transformer;
        }

        public String transform(String input) {
            return this.transformer.transform(input);
        }
    }

    private static interface Transformer {
        @Async
        public String transform(String var1);
    }
}

