/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class MockBeanWithInjectedFieldIntegrationTests {
    @MockBean
    private MyService myService;

    @Test
    public void fieldInjectionIntoMyServiceMockIsNotAttempted() {
        BDDMockito.given((Object)this.myService.getCount()).willReturn((Object)5);
        Assertions.assertThat((int)this.myService.getCount()).isEqualTo(5);
    }

    private static interface MyRepository {
        public List<Object> findAll();
    }

    private static class MyService {
        @Autowired
        private MyRepository repository;

        private MyService() {
        }

        public int getCount() {
            return this.repository.findAll().size();
        }
    }
}

