/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.mockito.BDDMockito;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.MockitoBeans;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class ResetMocksTestExecutionListenerTests {
    @Autowired
    private ApplicationContext context;

    @Test
    public void test001() {
        BDDMockito.given((Object)this.getMock("none").greeting()).willReturn((Object)"none");
        BDDMockito.given((Object)this.getMock("before").greeting()).willReturn((Object)"before");
        BDDMockito.given((Object)this.getMock("after").greeting()).willReturn((Object)"after");
    }

    @Test
    public void test002() {
        Assertions.assertThat((String)this.getMock("none").greeting()).isEqualTo((Object)"none");
        Assertions.assertThat((String)this.getMock("before").greeting()).isNull();
        Assertions.assertThat((String)this.getMock("after").greeting()).isNull();
    }

    public ExampleService getMock(String name) {
        return (ExampleService)this.context.getBean(name, ExampleService.class);
    }

    static class BrokenFactoryBean
    implements FactoryBean<String> {
        BrokenFactoryBean() {
        }

        public String getObject() {
            throw new IllegalStateException();
        }

        public Class<?> getObjectType() {
            return String.class;
        }

        public boolean isSingleton() {
            return true;
        }
    }

    @Configuration
    static class Config {
        Config() {
        }

        @Bean
        public ExampleService before(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.before());
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        public ExampleService after(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class, (MockSettings)MockReset.after());
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        public ExampleService none(MockitoBeans mockedBeans) {
            ExampleService mock = (ExampleService)Mockito.mock(ExampleService.class);
            mockedBeans.add((Object)mock);
            return mock;
        }

        @Bean
        @Lazy
        public ExampleService fail() {
            throw new RuntimeException();
        }

        @Bean
        public BrokenFactoryBean brokenFactoryBean() {
            return new BrokenFactoryBean();
        }
    }
}

