/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.cache.interceptor.CacheResolver;
import org.springframework.cache.interceptor.SimpleCacheResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Service;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

@RunWith(value=SpringRunner.class)
public class SpyBeanWithAopProxyTests {
    @SpyBean
    private DateService dateService;

    @Test
    public void verifyShouldUseProxyTarget() throws Exception {
        Long d1 = this.dateService.getDate(false);
        Thread.sleep(200L);
        Long d2 = this.dateService.getDate(false);
        Assertions.assertThat((Long)d1).isEqualTo((Object)d2);
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)1))).getDate(false);
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)1))).getDate(this.matchesFalse());
        ((DateService)Mockito.verify((Object)this.dateService, (VerificationMode)Mockito.times((int)1))).getDate(this.matchesAnyBoolean());
    }

    private boolean matchesFalse() {
        if (this.isTestingMockito1()) {
            Method method = ReflectionUtils.findMethod((Class)ClassUtils.resolveClassName((String)"org.mockito.Matchers", null), (String)"eq", (Class[])new Class[]{Boolean.TYPE});
            return (Boolean)ReflectionUtils.invokeMethod((Method)method, null, (Object[])new Object[]{false});
        }
        return ArgumentMatchers.eq((boolean)false);
    }

    private boolean matchesAnyBoolean() {
        if (this.isTestingMockito1()) {
            Method method = ReflectionUtils.findMethod((Class)ClassUtils.resolveClassName((String)"org.mockito.Matchers", null), (String)"anyBoolean");
            return (Boolean)ReflectionUtils.invokeMethod((Method)method, null);
        }
        return ArgumentMatchers.anyBoolean();
    }

    private boolean isTestingMockito1() {
        return ClassUtils.isPresent((String)"org.mockito.ReturnValues", null);
    }

    @Service
    static class DateService {
        DateService() {
        }

        @Cacheable(cacheNames={"test"})
        public Long getDate(boolean arg) {
            return System.nanoTime();
        }
    }

    @Configuration
    @EnableCaching(proxyTargetClass=true)
    @Import(value={DateService.class})
    static class Config {
        Config() {
        }

        @Bean
        public CacheResolver cacheResolver(CacheManager cacheManager) {
            SimpleCacheResolver resolver = new SimpleCacheResolver();
            resolver.setCacheManager(cacheManager);
            return resolver;
        }

        @Bean
        public ConcurrentMapCacheManager cacheManager() {
            ConcurrentMapCacheManager cacheManager = new ConcurrentMapCacheManager();
            cacheManager.setCacheNames(Arrays.asList("test"));
            return cacheManager;
        }
    }
}

