/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleService;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@DirtiesContext(classMode=DirtiesContext.ClassMode.BEFORE_EACH_TEST_METHOD)
public class SpyBeanWithDirtiesContextClassModeBeforeMethodIntegrationTests {
    @SpyBean
    private SimpleExampleService exampleService;
    @Autowired
    private ExampleServiceCaller caller;

    @Test
    public void testSpying() throws Exception {
        this.caller.sayGreeting();
        ((SimpleExampleService)Mockito.verify((Object)this.exampleService)).greeting();
    }

    @Configuration
    @Import(value={ExampleServiceCaller.class})
    static class Config {
        Config() {
        }
    }
}

