/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockingDetails;
import org.mockito.Mockito;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.boot.test.mock.mockito.example.SimpleExampleStringGenericService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
public class SpyBeanWithNameOnTestFieldForMultipleExistingBeansTests {
    @SpyBean(name="two")
    private SimpleExampleStringGenericService spy;

    @Test
    public void testSpying() {
        MockingDetails mockingDetails = Mockito.mockingDetails((Object)this.spy);
        Assertions.assertThat((boolean)mockingDetails.isSpy()).isTrue();
        Assertions.assertThat((String)mockingDetails.getMockCreationSettings().getMockName().toString()).isEqualTo((Object)"two");
    }

    @Configuration
    static class Config {
        Config() {
        }

        @Bean
        public SimpleExampleStringGenericService one() {
            return new SimpleExampleStringGenericService("one");
        }

        @Bean
        public SimpleExampleStringGenericService two() {
            return new SimpleExampleStringGenericService("two");
        }
    }
}

