/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.mockito;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Mockito;
import org.mockito.mock.MockCreationSettings;
import org.springframework.boot.test.mock.mockito.MockReset;
import org.springframework.boot.test.mock.mockito.QualifierDefinition;
import org.springframework.boot.test.mock.mockito.SpyDefinition;
import org.springframework.boot.test.mock.mockito.example.ExampleService;
import org.springframework.boot.test.mock.mockito.example.ExampleServiceCaller;
import org.springframework.boot.test.mock.mockito.example.RealExampleService;
import org.springframework.core.ResolvableType;

public class SpyDefinitionTests {
    private static final ResolvableType REAL_SERVICE_TYPE = ResolvableType.forClass(RealExampleService.class);

    @Test
    public void classToSpyMustNotBeNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new SpyDefinition(null, null, null, true, null)).withMessageContaining("TypeToSpy must not be null");
    }

    @Test
    public void createWithDefaults() {
        SpyDefinition definition = new SpyDefinition(null, REAL_SERVICE_TYPE, null, true, null);
        Assertions.assertThat((String)definition.getName()).isNull();
        Assertions.assertThat((Object)definition.getTypeToSpy()).isEqualTo((Object)REAL_SERVICE_TYPE);
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.AFTER);
        Assertions.assertThat((boolean)definition.isProxyTargetAware()).isTrue();
        Assertions.assertThat((Object)definition.getQualifier()).isNull();
    }

    @Test
    public void createExplicit() {
        QualifierDefinition qualifier = (QualifierDefinition)Mockito.mock(QualifierDefinition.class);
        SpyDefinition definition = new SpyDefinition("name", REAL_SERVICE_TYPE, MockReset.BEFORE, false, qualifier);
        Assertions.assertThat((String)definition.getName()).isEqualTo((Object)"name");
        Assertions.assertThat((Object)definition.getTypeToSpy()).isEqualTo((Object)REAL_SERVICE_TYPE);
        Assertions.assertThat((Comparable)definition.getReset()).isEqualTo((Object)MockReset.BEFORE);
        Assertions.assertThat((boolean)definition.isProxyTargetAware()).isFalse();
        Assertions.assertThat((Object)definition.getQualifier()).isEqualTo((Object)qualifier);
    }

    @Test
    public void createSpy() {
        SpyDefinition definition = new SpyDefinition("name", REAL_SERVICE_TYPE, MockReset.BEFORE, true, null);
        RealExampleService spy = (RealExampleService)definition.createSpy((Object)new RealExampleService("hello"));
        MockCreationSettings settings = Mockito.mockingDetails((Object)spy).getMockCreationSettings();
        Assertions.assertThat((Object)spy).isInstanceOf(ExampleService.class);
        Assertions.assertThat((String)settings.getMockName().toString()).isEqualTo((Object)"name");
        Assertions.assertThat((Object)settings.getDefaultAnswer()).isEqualTo((Object)Answers.CALLS_REAL_METHODS);
        Assertions.assertThat((Comparable)MockReset.get((Object)spy)).isEqualTo((Object)MockReset.BEFORE);
    }

    @Test
    public void createSpyWhenNullInstanceShouldThrowException() {
        SpyDefinition definition = new SpyDefinition("name", REAL_SERVICE_TYPE, MockReset.BEFORE, true, null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> definition.createSpy(null)).withMessageContaining("Instance must not be null");
    }

    @Test
    public void createSpyWhenWrongInstanceShouldThrowException() {
        SpyDefinition definition = new SpyDefinition("name", REAL_SERVICE_TYPE, MockReset.BEFORE, true, null);
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> definition.createSpy((Object)new ExampleServiceCaller(null))).withMessageContaining("must be an instance of");
    }

    @Test
    public void createSpyTwice() {
        SpyDefinition definition = new SpyDefinition("name", REAL_SERVICE_TYPE, MockReset.BEFORE, true, null);
        Object instance = new RealExampleService("hello");
        instance = definition.createSpy(instance);
        definition.createSpy(instance);
    }
}

