/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.mock.web;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootContextLoader;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.context.ServletContextAware;

@RunWith(value=SpringRunner.class)
@DirtiesContext
@ContextConfiguration(loader=SpringBootContextLoader.class)
@WebAppConfiguration(value="src/test/webapp")
public class SpringBootMockServletContextTests
implements ServletContextAware {
    private ServletContext servletContext;

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Test
    public void getResourceLocation() throws Exception {
        this.testResource("/inwebapp", "src/test/webapp");
        this.testResource("/inmetainfresources", "/META-INF/resources");
        this.testResource("/inresources", "/resources");
        this.testResource("/instatic", "/static");
        this.testResource("/inpublic", "/public");
    }

    private void testResource(String path, String expectedLocation) throws MalformedURLException {
        URL resource = this.servletContext.getResource(path);
        Assertions.assertThat((URL)resource).isNotNull();
        Assertions.assertThat((String)resource.getPath()).contains(new CharSequence[]{expectedLocation});
    }

    @Test
    public void getRootUrlExistsAndIsEmpty() throws Exception {
        SpringBootMockServletContext context = new SpringBootMockServletContext("src/test/doesntexist"){

            protected String getResourceLocation(String path) {
                return this.getResourceBasePathLocation(path);
            }
        };
        URL resource = context.getResource("/");
        Assertions.assertThat((URL)resource).isNotEqualTo((Object)Matchers.nullValue());
        File file = new File(URLDecoder.decode(resource.getPath(), "UTF-8"));
        Assertions.assertThat((File)file).exists().isDirectory();
        Object[] contents = file.list((dir, name) -> !".".equals(name) && !"..".equals(name));
        Assertions.assertThat((Object[])contents).isNotEqualTo((Object)Matchers.nullValue());
        Assertions.assertThat((int)contents.length).isEqualTo(0);
    }

    @Configuration
    static class Config {
        Config() {
        }
    }
}

