/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.net.URI;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.web.util.UriTemplateHandler;

public class LocalHostUriTemplateHandlerTests {
    @Test
    public void createWhenEnvironmentIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler(null)).withMessageContaining("Environment must not be null");
    }

    @Test
    public void createWhenSchemeIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler((Environment)new MockEnvironment(), null)).withMessageContaining("Scheme must not be null");
    }

    @Test
    public void createWhenHandlerIsNullShouldThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostUriTemplateHandler((Environment)new MockEnvironment(), "http", null)).withMessageContaining("Handler must not be null");
    }

    @Test
    public void getRootUriShouldUseLocalServerPort() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("local.server.port", "1234");
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo((Object)"http://localhost:1234");
    }

    @Test
    public void getRootUriWhenLocalServerPortMissingShouldUsePort8080() {
        MockEnvironment environment = new MockEnvironment();
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo((Object)"http://localhost:8080");
    }

    @Test
    public void getRootUriUsesCustomScheme() {
        MockEnvironment environment = new MockEnvironment();
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment, "https");
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo((Object)"https://localhost:8080");
    }

    @Test
    public void getRootUriShouldUseContextPath() {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("server.servlet.context-path", "/foo");
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment);
        Assertions.assertThat((String)handler.getRootUri()).isEqualTo((Object)"http://localhost:8080/foo");
    }

    @Test
    public void expandShouldUseCustomHandler() {
        MockEnvironment environment = new MockEnvironment();
        UriTemplateHandler uriTemplateHandler = (UriTemplateHandler)Mockito.mock(UriTemplateHandler.class);
        HashMap uriVariables = new HashMap();
        URI uri = URI.create("http://www.example.com");
        BDDMockito.given((Object)uriTemplateHandler.expand("https://localhost:8080/", uriVariables)).willReturn((Object)uri);
        LocalHostUriTemplateHandler handler = new LocalHostUriTemplateHandler((Environment)environment, "https", uriTemplateHandler);
        Assertions.assertThat((URI)handler.expand("/", uriVariables)).isEqualTo((Object)uri);
        ((UriTemplateHandler)Mockito.verify((Object)uriTemplateHandler)).expand("https://localhost:8080/", uriVariables);
    }
}

