/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.GenericServlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.NoTestRestTemplateBeanChecker;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.embedded.tomcat.TomcatServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT)
@DirtiesContext
public class TestRestTemplateContextCustomizerWithOverrideIntegrationTests {
    @Autowired
    private TestRestTemplate restTemplate;

    @Test
    public void test() {
        Assertions.assertThat((Object)this.restTemplate).isInstanceOf(CustomTestRestTemplate.class);
    }

    static class CustomTestRestTemplate
    extends TestRestTemplate {
        CustomTestRestTemplate() {
            super(new TestRestTemplate.HttpClientOption[0]);
        }
    }

    static class TestServlet
    extends GenericServlet {
        TestServlet() {
        }

        public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
            try (PrintWriter writer = response.getWriter();){
                writer.println("hello");
            }
        }
    }

    @Configuration
    @Import(value={TestServlet.class, NoTestRestTemplateBeanChecker.class})
    static class TestConfig {
        TestConfig() {
        }

        @Bean
        public TomcatServletWebServerFactory webServerFactory() {
            return new TomcatServletWebServerFactory(0);
        }

        @Bean
        public TestRestTemplate template() {
            return new CustomTestRestTemplate();
        }
    }
}

