/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.web.client.LocalHostUriTemplateHandler;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.http.client.support.BasicAuthenticationInterceptor;
import org.springframework.mock.env.MockEnvironment;
import org.springframework.mock.http.client.MockClientHttpRequest;
import org.springframework.mock.http.client.MockClientHttpResponse;
import org.springframework.test.util.ReflectionTestUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class TestRestTemplateTests {
    @Test
    public void fromRestTemplateBuilder() {
        RestTemplateBuilder builder = (RestTemplateBuilder)Mockito.mock(RestTemplateBuilder.class);
        RestTemplate delegate = new RestTemplate();
        BDDMockito.given((Object)builder.build()).willReturn((Object)delegate);
        Assertions.assertThat((Object)new TestRestTemplate(builder).getRestTemplate()).isEqualTo((Object)delegate);
    }

    @Test
    public void simple() {
        Assertions.assertThat((Object)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getRestTemplate().getRequestFactory()).isInstanceOf(HttpComponentsClientHttpRequestFactory.class);
    }

    @Test
    public void doNotReplaceCustomRequestFactory() {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]).requestFactory(OkHttp3ClientHttpRequestFactory.class);
        TestRestTemplate testRestTemplate = new TestRestTemplate(builder);
        Assertions.assertThat((Object)testRestTemplate.getRestTemplate().getRequestFactory()).isInstanceOf(OkHttp3ClientHttpRequestFactory.class);
    }

    @Test
    public void getRootUriRootUriSetViaRestTemplateBuilder() {
        String rootUri = "http://example.com";
        RestTemplateBuilder delegate = new RestTemplateBuilder(new RestTemplateCustomizer[0]).rootUri(rootUri);
        Assertions.assertThat((String)new TestRestTemplate(delegate).getRootUri()).isEqualTo((Object)rootUri);
    }

    @Test
    public void getRootUriRootUriSetViaLocalHostUriTemplateHandler() {
        String rootUri = "http://example.com";
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        LocalHostUriTemplateHandler templateHandler = (LocalHostUriTemplateHandler)Mockito.mock(LocalHostUriTemplateHandler.class);
        BDDMockito.given((Object)templateHandler.getRootUri()).willReturn((Object)rootUri);
        template.setUriTemplateHandler((UriTemplateHandler)templateHandler);
        Assertions.assertThat((String)template.getRootUri()).isEqualTo((Object)rootUri);
    }

    @Test
    public void getRootUriRootUriNotSet() {
        Assertions.assertThat((String)new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]).getRootUri()).isEqualTo((Object)"");
    }

    @Test
    public void authenticated() {
        Assertions.assertThat((Object)new TestRestTemplate("user", "password", new TestRestTemplate.HttpClientOption[0]).getRestTemplate().getRequestFactory()).isInstanceOf(InterceptingClientHttpRequestFactory.class);
    }

    @Test
    public void options() {
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[]{TestRestTemplate.HttpClientOption.ENABLE_REDIRECTS});
        TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory factory = (TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory)template.getRestTemplate().getRequestFactory();
        RequestConfig config = factory.getRequestConfig();
        Assertions.assertThat((boolean)config.isRedirectsEnabled()).isTrue();
    }

    @Test
    public void restOperationsAreAvailable() {
        RestTemplate delegate = (RestTemplate)Mockito.mock(RestTemplate.class);
        BDDMockito.given((Object)delegate.getRequestFactory()).willReturn((Object)new SimpleClientHttpRequestFactory());
        BDDMockito.given((Object)delegate.getUriTemplateHandler()).willReturn((Object)new DefaultUriBuilderFactory());
        RestTemplateBuilder builder = (RestTemplateBuilder)Mockito.mock(RestTemplateBuilder.class);
        BDDMockito.given((Object)builder.build()).willReturn((Object)delegate);
        final TestRestTemplate restTemplate = new TestRestTemplate(builder);
        ReflectionUtils.doWithMethods(RestOperations.class, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Method equivalent = ReflectionUtils.findMethod(TestRestTemplate.class, (String)method.getName(), (Class[])method.getParameterTypes());
                ((ObjectAssert)Assertions.assertThat((Object)equivalent).as("Method %s not found", new Object[]{method})).isNotNull();
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)Modifier.isPublic(equivalent.getModifiers())).as("Method %s should have been public", new Object[]{equivalent})).isTrue();
                try {
                    equivalent.invoke((Object)restTemplate, this.mockArguments(method.getParameterTypes()));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
            }

            private Object[] mockArguments(Class<?>[] parameterTypes) throws Exception {
                Object[] arguments = new Object[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    arguments[i] = this.mockArgument(parameterTypes[i]);
                }
                return arguments;
            }

            private Object mockArgument(Class<?> type) throws Exception {
                if (String.class.equals(type)) {
                    return "String";
                }
                if (Object[].class.equals(type)) {
                    return new Object[0];
                }
                if (URI.class.equals(type)) {
                    return new URI("http://localhost");
                }
                if (HttpMethod.class.equals(type)) {
                    return HttpMethod.GET;
                }
                if (Class.class.equals(type)) {
                    return Object.class;
                }
                if (RequestEntity.class.equals(type)) {
                    return new RequestEntity(HttpMethod.GET, new URI("http://localhost"));
                }
                return Mockito.mock(type);
            }
        }, method -> Modifier.isPublic(method.getModifiers()));
    }

    @Test
    public void withBasicAuthAddsBasicAuthInterceptorWhenNotAlreadyPresent() {
        TestRestTemplate originalTemplate = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        TestRestTemplate basicAuthTemplate = originalTemplate.withBasicAuth("user", "password");
        Assertions.assertThat((List)basicAuthTemplate.getRestTemplate().getMessageConverters()).containsExactlyElementsOf((Iterable)originalTemplate.getRestTemplate().getMessageConverters());
        Assertions.assertThat((Object)basicAuthTemplate.getRestTemplate().getRequestFactory()).isInstanceOf(InterceptingClientHttpRequestFactory.class);
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)basicAuthTemplate.getRestTemplate().getRequestFactory(), (String)"requestFactory")).isInstanceOf(TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory.class);
        Assertions.assertThat((Object)basicAuthTemplate.getRestTemplate().getUriTemplateHandler()).isSameAs((Object)originalTemplate.getRestTemplate().getUriTemplateHandler());
        Assertions.assertThat((List)basicAuthTemplate.getRestTemplate().getInterceptors()).hasSize(1);
        this.assertBasicAuthorizationInterceptorCredentials(basicAuthTemplate, "user", "password");
    }

    @Test
    public void withBasicAuthReplacesBasicAuthInterceptorWhenAlreadyPresent() {
        TestRestTemplate original = new TestRestTemplate("foo", "bar", new TestRestTemplate.HttpClientOption[0]).withBasicAuth("replace", "replace");
        TestRestTemplate basicAuth = original.withBasicAuth("user", "password");
        Assertions.assertThat((List)basicAuth.getRestTemplate().getMessageConverters()).containsExactlyElementsOf((Iterable)original.getRestTemplate().getMessageConverters());
        Assertions.assertThat((Object)basicAuth.getRestTemplate().getRequestFactory()).isInstanceOf(InterceptingClientHttpRequestFactory.class);
        Assertions.assertThat((Object)ReflectionTestUtils.getField((Object)basicAuth.getRestTemplate().getRequestFactory(), (String)"requestFactory")).isInstanceOf(TestRestTemplate.CustomHttpComponentsClientHttpRequestFactory.class);
        Assertions.assertThat((Object)basicAuth.getRestTemplate().getUriTemplateHandler()).isSameAs((Object)original.getRestTemplate().getUriTemplateHandler());
        Assertions.assertThat((List)basicAuth.getRestTemplate().getInterceptors()).hasSize(1);
        this.assertBasicAuthorizationInterceptorCredentials(basicAuth, "user", "password");
    }

    @Test
    public void withBasicAuthDoesNotResetErrorHandler() {
        TestRestTemplate originalTemplate = new TestRestTemplate("foo", "bar", new TestRestTemplate.HttpClientOption[0]);
        ResponseErrorHandler errorHandler = (ResponseErrorHandler)Mockito.mock(ResponseErrorHandler.class);
        originalTemplate.getRestTemplate().setErrorHandler(errorHandler);
        TestRestTemplate basicAuthTemplate = originalTemplate.withBasicAuth("user", "password");
        Assertions.assertThat((Object)basicAuthTemplate.getRestTemplate().getErrorHandler()).isSameAs((Object)errorHandler);
    }

    @Test
    public void deleteHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::delete);
    }

    @Test
    public void exchangeWithRequestEntityAndClassHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(new RequestEntity(HttpMethod.GET, relativeUri), String.class));
    }

    @Test
    public void exchangeWithRequestEntityAndParameterizedTypeReferenceHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(new RequestEntity(HttpMethod.GET, relativeUri), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}));
    }

    @Test
    public void exchangeHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(relativeUri, HttpMethod.GET, new HttpEntity((Object)new byte[0]), String.class));
    }

    @Test
    public void exchangeWithParameterizedTypeReferenceHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.exchange(relativeUri, HttpMethod.GET, new HttpEntity((Object)new byte[0]), (ParameterizedTypeReference)new ParameterizedTypeReference<String>(){}));
    }

    @Test
    public void executeHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.execute(relativeUri, HttpMethod.GET, null, null));
    }

    @Test
    public void getForEntityHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.getForEntity(relativeUri, String.class));
    }

    @Test
    public void getForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.getForObject(relativeUri, String.class);
        });
    }

    @Test
    public void headForHeadersHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::headForHeaders);
    }

    @Test
    public void optionsForAllowHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling(TestRestTemplate::optionsForAllow);
    }

    @Test
    public void patchForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.patchForObject(relativeUri, (Object)"hello", String.class);
        });
    }

    @Test
    public void postForEntityHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.postForEntity(relativeUri, (Object)"hello", String.class));
    }

    @Test
    public void postForLocationHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.postForLocation(relativeUri, (Object)"hello"));
    }

    @Test
    public void postForObjectHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> {
            String cfr_ignored_0 = (String)testRestTemplate.postForObject(relativeUri, (Object)"hello", String.class);
        });
    }

    @Test
    public void putHandlesRelativeUris() throws IOException {
        this.verifyRelativeUriHandling((testRestTemplate, relativeUri) -> testRestTemplate.put(relativeUri, (Object)"hello"));
    }

    private void verifyRelativeUriHandling(TestRestTemplateCallback callback) throws IOException {
        ClientHttpRequestFactory requestFactory = (ClientHttpRequestFactory)Mockito.mock(ClientHttpRequestFactory.class);
        MockClientHttpRequest request = new MockClientHttpRequest();
        request.setResponse((ClientHttpResponse)new MockClientHttpResponse(new byte[0], HttpStatus.OK));
        URI absoluteUri = URI.create("http://localhost:8080/a/b/c.txt?param=%7Bsomething%7D");
        BDDMockito.given((Object)requestFactory.createRequest((URI)ArgumentMatchers.eq((Object)absoluteUri), (HttpMethod)ArgumentMatchers.any(HttpMethod.class))).willReturn((Object)request);
        TestRestTemplate template = new TestRestTemplate(new TestRestTemplate.HttpClientOption[0]);
        template.getRestTemplate().setRequestFactory(requestFactory);
        LocalHostUriTemplateHandler uriTemplateHandler = new LocalHostUriTemplateHandler((Environment)new MockEnvironment());
        template.setUriTemplateHandler((UriTemplateHandler)uriTemplateHandler);
        callback.doWithTestRestTemplate(template, URI.create("/a/b/c.txt?param=%7Bsomething%7D"));
        ((ClientHttpRequestFactory)Mockito.verify((Object)requestFactory)).createRequest((URI)ArgumentMatchers.eq((Object)absoluteUri), (HttpMethod)ArgumentMatchers.any(HttpMethod.class));
    }

    private void assertBasicAuthorizationInterceptorCredentials(TestRestTemplate testRestTemplate, String username, String password) {
        List requestFactoryInterceptors = (List)ReflectionTestUtils.getField((Object)testRestTemplate.getRestTemplate().getRequestFactory(), (String)"interceptors");
        Assertions.assertThat((List)requestFactoryInterceptors).hasSize(1);
        ClientHttpRequestInterceptor interceptor = (ClientHttpRequestInterceptor)requestFactoryInterceptors.get(0);
        Assertions.assertThat((Object)interceptor).isInstanceOf(BasicAuthenticationInterceptor.class);
        Assertions.assertThat((Object)interceptor).hasFieldOrPropertyWithValue("username", (Object)username);
        Assertions.assertThat((Object)interceptor).hasFieldOrPropertyWithValue("password", (Object)password);
    }

    private static interface TestRestTemplateCallback {
        public void doWithTestRestTemplate(TestRestTemplate var1, URI var2);
    }
}

