/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.htmlunit.webdriver;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.net.URL;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.openqa.selenium.Capabilities;
import org.springframework.boot.test.web.htmlunit.webdriver.LocalHostWebConnectionHtmlUnitDriver;
import org.springframework.core.env.Environment;
import org.springframework.mock.env.MockEnvironment;

public class LocalHostWebConnectionHtmlUnitDriverTests {
    @Mock
    private WebClient webClient;

    public LocalHostWebConnectionHtmlUnitDriverTests() {
        MockitoAnnotations.initMocks((Object)this);
        BDDMockito.given((Object)this.webClient.getOptions()).willReturn((Object)new WebClientOptions());
    }

    @Test
    public void createWhenEnvironmentIsNullWillThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostWebConnectionHtmlUnitDriver(null)).withMessageContaining("Environment must not be null");
    }

    @Test
    public void createWithJavascriptFlagWhenEnvironmentIsNullWillThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostWebConnectionHtmlUnitDriver(null, true)).withMessageContaining("Environment must not be null");
    }

    @Test
    public void createWithBrowserVersionWhenEnvironmentIsNullWillThrowException() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostWebConnectionHtmlUnitDriver(null, BrowserVersion.CHROME)).withMessageContaining("Environment must not be null");
    }

    @Test
    public void createWithCapabilitiesWhenEnvironmentIsNullWillThrowException() {
        Capabilities capabilities = (Capabilities)Mockito.mock(Capabilities.class);
        BDDMockito.given((Object)capabilities.getBrowserName()).willReturn((Object)"htmlunit");
        BDDMockito.given((Object)capabilities.getVersion()).willReturn((Object)"chrome");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LocalHostWebConnectionHtmlUnitDriver(null, capabilities)).withMessageContaining("Environment must not be null");
    }

    @Test
    public void getWhenUrlIsRelativeAndNoPortWillUseLocalhost8080() throws Exception {
        MockEnvironment environment = new MockEnvironment();
        TestLocalHostWebConnectionHtmlUnitDriver driver = new TestLocalHostWebConnectionHtmlUnitDriver((Environment)environment);
        driver.get("/test");
        ((WebClient)Mockito.verify((Object)this.webClient)).getPage((WebWindow)ArgumentMatchers.any(WebWindow.class), this.requestToUrl(new URL("http://localhost:8080/test")));
    }

    @Test
    public void getWhenUrlIsRelativeAndHasPortWillUseLocalhostPort() throws Exception {
        MockEnvironment environment = new MockEnvironment();
        environment.setProperty("local.server.port", "8181");
        TestLocalHostWebConnectionHtmlUnitDriver driver = new TestLocalHostWebConnectionHtmlUnitDriver((Environment)environment);
        driver.get("/test");
        ((WebClient)Mockito.verify((Object)this.webClient)).getPage((WebWindow)ArgumentMatchers.any(WebWindow.class), this.requestToUrl(new URL("http://localhost:8181/test")));
    }

    private WebRequest requestToUrl(URL url) {
        return (WebRequest)ArgumentMatchers.argThat((ArgumentMatcher)new WebRequestUrlArgumentMatcher(url));
    }

    private static final class WebRequestUrlArgumentMatcher
    implements ArgumentMatcher<WebRequest> {
        private final URL expectedUrl;

        private WebRequestUrlArgumentMatcher(URL expectedUrl) {
            this.expectedUrl = expectedUrl;
        }

        public boolean matches(WebRequest argument) {
            return argument.getUrl().equals(this.expectedUrl);
        }
    }

    public class TestLocalHostWebConnectionHtmlUnitDriver
    extends LocalHostWebConnectionHtmlUnitDriver {
        public TestLocalHostWebConnectionHtmlUnitDriver(Environment environment) {
            super(environment);
        }

        public WebClient getWebClient() {
            return LocalHostWebConnectionHtmlUnitDriverTests.this.webClient;
        }
    }
}

