/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import org.assertj.core.api.AssertProvider;
import org.springframework.boot.test.json.JsonContentAssert;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public final class JsonContent<T>
implements AssertProvider<JsonContentAssert> {
    private final Class<?> resourceLoadClass;
    private final ResolvableType type;
    private final String json;

    public JsonContent(Class<?> resourceLoadClass, ResolvableType type, String json) {
        Assert.notNull(resourceLoadClass, (String)"ResourceLoadClass must not be null");
        Assert.notNull((Object)json, (String)"JSON must not be null");
        this.resourceLoadClass = resourceLoadClass;
        this.type = type;
        this.json = json;
    }

    @Deprecated
    public JsonContentAssert assertThat() {
        return new JsonContentAssert(this.resourceLoadClass, this.json);
    }

    public String getJson() {
        return this.json;
    }

    public String toString() {
        String createdFrom = this.type != null ? " created from " + this.type : "";
        return "JsonContent " + this.json + createdFrom;
    }
}

