/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.system;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.springframework.boot.ansi.AnsiOutput;
import org.springframework.boot.test.system.CapturedOutput;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class OutputCapture
implements CapturedOutput {
    private final Deque<SystemCapture> systemCaptures = new ArrayDeque<SystemCapture>();
    private AnsiOutputState ansiOutputState;
    private final AtomicReference<String> out = new AtomicReference<Object>(null);
    private final AtomicReference<String> err = new AtomicReference<Object>(null);
    private final AtomicReference<String> all = new AtomicReference<Object>(null);

    OutputCapture() {
    }

    final void push() {
        if (this.systemCaptures.isEmpty()) {
            this.ansiOutputState = AnsiOutputState.saveAndDisable();
        }
        this.clearExisting();
        this.systemCaptures.addLast(new SystemCapture(this::clearExisting));
    }

    final void pop() {
        this.clearExisting();
        this.systemCaptures.removeLast().release();
        if (this.systemCaptures.isEmpty() && this.ansiOutputState != null) {
            this.ansiOutputState.restore();
            this.ansiOutputState = null;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CapturedOutput || obj instanceof CharSequence) {
            return this.getAll().equals(obj.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.getAll();
    }

    @Override
    public String getAll() {
        return this.get(this.all, type -> true);
    }

    @Override
    public String getOut() {
        return this.get(this.out, Type.OUT::equals);
    }

    @Override
    public String getErr() {
        return this.get(this.err, Type.ERR::equals);
    }

    void reset() {
        this.clearExisting();
        this.systemCaptures.peek().reset();
    }

    void clearExisting() {
        this.out.set(null);
        this.err.set(null);
        this.all.set(null);
    }

    private String get(AtomicReference<String> existing, Predicate<Type> filter) {
        Assert.state((!this.systemCaptures.isEmpty() ? 1 : 0) != 0, (String)"No system captures found. Please check your output capture registration.");
        String result = existing.get();
        if (result == null) {
            result = this.build(filter);
            existing.compareAndSet(null, result);
        }
        return result;
    }

    String build(Predicate<Type> filter) {
        StringBuilder builder = new StringBuilder();
        for (SystemCapture systemCapture : this.systemCaptures) {
            systemCapture.append(builder, filter);
        }
        return builder.toString();
    }

    private static class AnsiOutputState {
        private AnsiOutput.Enabled saved = AnsiOutput.getEnabled();

        AnsiOutputState() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)AnsiOutput.Enabled.NEVER);
        }

        void restore() {
            AnsiOutput.setEnabled((AnsiOutput.Enabled)this.saved);
        }

        static AnsiOutputState saveAndDisable() {
            if (!ClassUtils.isPresent((String)"org.springframework.boot.ansi.AnsiOutput", (ClassLoader)OutputCapture.class.getClassLoader())) {
                return null;
            }
            return new AnsiOutputState();
        }
    }

    private static class SystemCapture {
        private final Runnable onCapture;
        private final Object monitor = new Object();
        private final PrintStreamCapture out;
        private final PrintStreamCapture err;
        private final List<CapturedString> capturedStrings = new ArrayList<CapturedString>();

        SystemCapture(Runnable onCapture) {
            this.onCapture = onCapture;
            this.out = new PrintStreamCapture(System.out, this::captureOut);
            this.err = new PrintStreamCapture(System.err, this::captureErr);
            System.setOut(this.out);
            System.setErr(this.err);
        }

        void release() {
            System.setOut(this.out.getParent());
            System.setErr(this.err.getParent());
        }

        private void captureOut(String string) {
            this.capture(new CapturedString(Type.OUT, string));
        }

        private void captureErr(String string) {
            this.capture(new CapturedString(Type.ERR, string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void capture(CapturedString e) {
            Object object = this.monitor;
            synchronized (object) {
                this.onCapture.run();
                this.capturedStrings.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void append(StringBuilder builder, Predicate<Type> filter) {
            Object object = this.monitor;
            synchronized (object) {
                for (CapturedString stringCapture : this.capturedStrings) {
                    if (!filter.test(stringCapture.getType())) continue;
                    builder.append(stringCapture);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.capturedStrings.clear();
            }
        }
    }

    static enum Type {
        OUT,
        ERR;

    }

    private static class CapturedString {
        private final Type type;
        private final String string;

        CapturedString(Type type, String string) {
            this.type = type;
            this.string = string;
        }

        Type getType() {
            return this.type;
        }

        public String toString() {
            return this.string;
        }
    }

    private static class OutputStreamCapture
    extends OutputStream {
        private final PrintStream systemStream;
        private final Consumer<String> copy;

        OutputStreamCapture(PrintStream systemStream, Consumer<String> copy) {
            this.systemStream = systemStream;
            this.copy = copy;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)(b & 0xFF)});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.copy.accept(new String(b, off, len));
            this.systemStream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.systemStream.flush();
        }
    }

    private static class PrintStreamCapture
    extends PrintStream {
        private final PrintStream parent;

        PrintStreamCapture(PrintStream parent, Consumer<String> copy) {
            super(new OutputStreamCapture(PrintStreamCapture.getSystemStream(parent), copy));
            this.parent = parent;
        }

        PrintStream getParent() {
            return this.parent;
        }

        private static PrintStream getSystemStream(PrintStream printStream) {
            while (printStream instanceof PrintStreamCapture) {
                PrintStreamCapture printStreamCapture = (PrintStreamCapture)printStream;
                printStream = printStreamCapture.getParent();
            }
            return printStream;
        }
    }
}

