/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import jakarta.servlet.ServletContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationHook;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.test.context.ReactiveWebMergedContextConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.SpringBootTestAnnotation;
import org.springframework.boot.test.mock.web.SpringBootMockServletContext;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.boot.web.reactive.context.GenericReactiveWebApplicationContext;
import org.springframework.boot.web.servlet.support.ServletContextApplicationContextInitializer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.SpringVersion;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextLoadException;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.aot.AotContextLoader;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.support.AnnotationConfigContextLoaderUtils;
import org.springframework.test.context.support.TestPropertySourceUtils;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.function.ThrowingSupplier;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class SpringBootContextLoader
extends AbstractContextLoader
implements AotContextLoader {
    private static final Consumer<SpringApplication> ALREADY_CONFIGURED = springApplication -> {};

    public ApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, Mode.STANDARD, null);
    }

    public ApplicationContext loadContextForAotProcessing(MergedContextConfiguration mergedConfig) throws Exception {
        return this.loadContext(mergedConfig, Mode.AOT_PROCESSING, null);
    }

    public ApplicationContext loadContextForAotRuntime(MergedContextConfiguration mergedConfig, ApplicationContextInitializer<ConfigurableApplicationContext> initializer) throws Exception {
        return this.loadContext(mergedConfig, Mode.AOT_RUNTIME, initializer);
    }

    private ApplicationContext loadContext(MergedContextConfiguration mergedConfig, Mode mode, ApplicationContextInitializer<ConfigurableApplicationContext> initializer) throws Exception {
        this.assertHasClassesOrLocations(mergedConfig);
        SpringBootTestAnnotation annotation = SpringBootTestAnnotation.get(mergedConfig);
        String[] args = annotation.getArgs();
        SpringBootTest.UseMainMethod useMainMethod = annotation.getUseMainMethod();
        Method mainMethod = this.getMainMethod(mergedConfig, useMainMethod);
        if (mainMethod != null) {
            ContextLoaderHook hook = new ContextLoaderHook(mode, initializer, application -> this.configure(mergedConfig, (SpringApplication)application));
            return hook.runMain(() -> ReflectionUtils.invokeMethod((Method)mainMethod, null, (Object[])new Object[]{args}));
        }
        SpringApplication application2 = this.getSpringApplication();
        this.configure(mergedConfig, application2);
        ContextLoaderHook hook = new ContextLoaderHook(mode, initializer, ALREADY_CONFIGURED);
        return hook.run((ThrowingSupplier<ConfigurableApplicationContext>)((ThrowingSupplier)() -> application2.run(args)));
    }

    private void assertHasClassesOrLocations(MergedContextConfiguration mergedConfig) {
        boolean hasClasses = !ObjectUtils.isEmpty((Object[])mergedConfig.getClasses());
        boolean hasLocations = !ObjectUtils.isEmpty((Object[])mergedConfig.getLocations());
        Assert.state((hasClasses || hasLocations ? 1 : 0) != 0, () -> "No configuration classes or locations found in @SpringApplicationConfiguration. For default configuration detection to work you need Spring 4.0.3 or better (found " + SpringVersion.getVersion() + ").");
    }

    private Method getMainMethod(MergedContextConfiguration mergedConfig, SpringBootTest.UseMainMethod useMainMethod) {
        Method mainMethod;
        if (useMainMethod == SpringBootTest.UseMainMethod.NEVER) {
            return null;
        }
        Assert.state((mergedConfig.getParent() == null ? 1 : 0) != 0, () -> "UseMainMethod.%s cannot be used with @ContextHierarchy tests".formatted(new Object[]{useMainMethod}));
        Class springBootConfiguration = Arrays.stream(mergedConfig.getClasses()).filter(this::isSpringBootConfiguration).findFirst().orElse(null);
        Assert.state((springBootConfiguration != null || useMainMethod == SpringBootTest.UseMainMethod.WHEN_AVAILABLE ? 1 : 0) != 0, (String)"Cannot use main method as no @SpringBootConfiguration-annotated class is available");
        Method method = mainMethod = springBootConfiguration != null ? ReflectionUtils.findMethod((Class)springBootConfiguration, (String)"main", (Class[])new Class[]{String[].class}) : null;
        if (mainMethod == null && KotlinDetector.isKotlinPresent()) {
            try {
                Class kotlinClass = ClassUtils.forName((String)(springBootConfiguration.getName() + "Kt"), (ClassLoader)springBootConfiguration.getClassLoader());
                mainMethod = ReflectionUtils.findMethod((Class)kotlinClass, (String)"main", (Class[])new Class[]{String[].class});
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        Assert.state((mainMethod != null || useMainMethod == SpringBootTest.UseMainMethod.WHEN_AVAILABLE ? 1 : 0) != 0, () -> "Main method not found on '%s'".formatted(springBootConfiguration.getName()));
        return mainMethod;
    }

    private boolean isSpringBootConfiguration(Class<?> candidate) {
        return MergedAnnotations.from(candidate, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).isPresent(SpringBootConfiguration.class);
    }

    private void configure(MergedContextConfiguration mergedConfig, SpringApplication application) {
        application.setMainApplicationClass(mergedConfig.getTestClass());
        application.addPrimarySources(Arrays.asList(mergedConfig.getClasses()));
        application.getSources().addAll(Arrays.asList(mergedConfig.getLocations()));
        List<ApplicationContextInitializer<?>> initializers = this.getInitializers(mergedConfig, application);
        if (mergedConfig instanceof WebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.SERVLET);
            if (!this.isEmbeddedWebEnvironment(mergedConfig)) {
                new WebConfigurer().configure(mergedConfig, application, initializers);
            }
        } else if (mergedConfig instanceof ReactiveWebMergedContextConfiguration) {
            application.setWebApplicationType(WebApplicationType.REACTIVE);
        } else {
            application.setWebApplicationType(WebApplicationType.NONE);
        }
        application.setApplicationContextFactory(webApplicationType -> this.getApplicationContextFactory(mergedConfig, webApplicationType));
        if (mergedConfig.getParent() != null) {
            application.setBannerMode(Banner.Mode.OFF);
        }
        application.setInitializers(initializers);
        ConfigurableEnvironment environment = this.getEnvironment();
        if (environment != null) {
            this.prepareEnvironment(mergedConfig, application, environment, false);
            application.setEnvironment(environment);
        } else {
            application.addListeners(new ApplicationListener[]{new PrepareEnvironmentListener(mergedConfig)});
        }
    }

    private ConfigurableApplicationContext getApplicationContextFactory(MergedContextConfiguration mergedConfig, WebApplicationType webApplicationType) {
        if (webApplicationType != WebApplicationType.NONE && !this.isEmbeddedWebEnvironment(mergedConfig)) {
            if (webApplicationType == WebApplicationType.REACTIVE) {
                return new GenericReactiveWebApplicationContext();
            }
            if (webApplicationType == WebApplicationType.SERVLET) {
                return new GenericWebApplicationContext();
            }
        }
        return ApplicationContextFactory.DEFAULT.create(webApplicationType);
    }

    private void prepareEnvironment(MergedContextConfiguration mergedConfig, SpringApplication application, ConfigurableEnvironment environment, boolean applicationEnvironment) {
        this.setActiveProfiles(environment, mergedConfig.getActiveProfiles(), applicationEnvironment);
        ResourceLoader resourceLoader = application.getResourceLoader() != null ? application.getResourceLoader() : new DefaultResourceLoader(null);
        TestPropertySourceUtils.addPropertiesFilesToEnvironment((ConfigurableEnvironment)environment, (ResourceLoader)resourceLoader, (String[])mergedConfig.getPropertySourceLocations());
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment((ConfigurableEnvironment)environment, (String[])this.getInlinedProperties(mergedConfig));
    }

    private void setActiveProfiles(ConfigurableEnvironment environment, String[] profiles, boolean applicationEnvironment) {
        if (ObjectUtils.isEmpty((Object[])profiles)) {
            return;
        }
        if (!applicationEnvironment) {
            environment.setActiveProfiles(profiles);
        }
        String[] pairs = new String[profiles.length];
        for (int i = 0; i < profiles.length; ++i) {
            pairs[i] = "spring.profiles.active[" + i + "]=" + profiles[i];
        }
        TestPropertyValues.of(pairs).applyTo(environment, TestPropertyValues.Type.MAP, "active-test-profiles");
    }

    protected SpringApplication getSpringApplication() {
        return new SpringApplication(new Class[0]);
    }

    protected ConfigurableEnvironment getEnvironment() {
        return null;
    }

    protected String[] getInlinedProperties(MergedContextConfiguration mergedConfig) {
        ArrayList<String> properties = new ArrayList<String>();
        properties.add("spring.jmx.enabled=false");
        properties.addAll(Arrays.asList(mergedConfig.getPropertySourceProperties()));
        return StringUtils.toStringArray(properties);
    }

    protected List<ApplicationContextInitializer<?>> getInitializers(MergedContextConfiguration mergedConfig, SpringApplication application) {
        ArrayList initializers = new ArrayList();
        for (ContextCustomizer contextCustomizer : mergedConfig.getContextCustomizers()) {
            initializers.add(new ContextCustomizerAdapter(contextCustomizer, mergedConfig));
        }
        initializers.addAll(application.getInitializers());
        for (Class initializerClass : mergedConfig.getContextInitializerClasses()) {
            initializers.add((ApplicationContextInitializer)BeanUtils.instantiateClass((Class)initializerClass));
        }
        if (mergedConfig.getParent() != null) {
            ApplicationContext parentApplicationContext = mergedConfig.getParentApplicationContext();
            initializers.add(new ParentContextApplicationContextInitializer(parentApplicationContext));
        }
        return initializers;
    }

    private boolean isEmbeddedWebEnvironment(MergedContextConfiguration mergedConfig) {
        return SpringBootTestAnnotation.get(mergedConfig).getWebEnvironment().isEmbedded();
    }

    public void processContextConfiguration(ContextConfigurationAttributes configAttributes) {
        super.processContextConfiguration(configAttributes);
        if (!configAttributes.hasResources()) {
            Class[] defaultConfigClasses = this.detectDefaultConfigurationClasses(configAttributes.getDeclaringClass());
            configAttributes.setClasses(defaultConfigClasses);
        }
    }

    protected Class<?>[] detectDefaultConfigurationClasses(Class<?> declaringClass) {
        return AnnotationConfigContextLoaderUtils.detectDefaultConfigurationClasses(declaringClass);
    }

    protected String[] getResourceSuffixes() {
        return new String[]{"-context.xml", "Context.groovy"};
    }

    protected String getResourceSuffix() {
        throw new IllegalStateException();
    }

    private static enum Mode {
        STANDARD,
        AOT_PROCESSING,
        AOT_RUNTIME;

    }

    private static class ContextLoaderHook
    implements SpringApplicationHook {
        private final Mode mode;
        private final ApplicationContextInitializer<ConfigurableApplicationContext> initializer;
        private final Consumer<SpringApplication> configurer;
        private final List<ApplicationContext> contexts = Collections.synchronizedList(new ArrayList());
        private final List<ApplicationContext> failedContexts = Collections.synchronizedList(new ArrayList());

        ContextLoaderHook(Mode mode, ApplicationContextInitializer<ConfigurableApplicationContext> initializer, Consumer<SpringApplication> configurer) {
            this.mode = mode;
            this.initializer = initializer;
            this.configurer = configurer;
        }

        public SpringApplicationRunListener getRunListener(final SpringApplication application) {
            return new SpringApplicationRunListener(){

                public void starting(ConfigurableBootstrapContext bootstrapContext) {
                    configurer.accept(application);
                    if (mode == Mode.AOT_RUNTIME) {
                        ApplicationContextInitializer[] applicationContextInitializerArray = new ApplicationContextInitializer[1];
                        applicationContextInitializerArray[0] = arg_0 -> initializer.initialize(arg_0);
                        application.addInitializers(applicationContextInitializerArray);
                    }
                }

                public void contextLoaded(ConfigurableApplicationContext context) {
                    contexts.add((ApplicationContext)context);
                    if (mode == Mode.AOT_PROCESSING) {
                        throw new SpringApplication.AbandonedRunException(context);
                    }
                }

                public void failed(ConfigurableApplicationContext context, Throwable exception) {
                    failedContexts.add((ApplicationContext)context);
                }
            };
        }

        private <T> ApplicationContext runMain(Runnable action) throws Exception {
            return this.run((ThrowingSupplier<ConfigurableApplicationContext>)((ThrowingSupplier)() -> {
                action.run();
                return null;
            }));
        }

        private ApplicationContext run(ThrowingSupplier<ConfigurableApplicationContext> action) throws Exception {
            try {
                ConfigurableApplicationContext context2 = (ConfigurableApplicationContext)SpringApplication.withHook((SpringApplicationHook)this, action);
                if (context2 != null) {
                    return context2;
                }
            }
            catch (SpringApplication.AbandonedRunException context2) {
            }
            catch (Exception ex) {
                if (this.failedContexts.size() == 1) {
                    throw new ContextLoadException(this.failedContexts.get(0), (Throwable)ex);
                }
                throw ex;
            }
            List<ApplicationContext> rootContexts = this.contexts.stream().filter(context -> context.getParent() == null).toList();
            Assert.state((!rootContexts.isEmpty() ? 1 : 0) != 0, (String)"No root application context located");
            Assert.state((rootContexts.size() == 1 ? 1 : 0) != 0, (String)"No unique root application context located");
            return rootContexts.get(0);
        }
    }

    private static class WebConfigurer {
        private WebConfigurer() {
        }

        void configure(MergedContextConfiguration mergedConfig, SpringApplication application, List<ApplicationContextInitializer<?>> initializers) {
            WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
            this.addMockServletContext(initializers, webMergedConfig);
        }

        private void addMockServletContext(List<ApplicationContextInitializer<?>> initializers, WebMergedContextConfiguration webMergedConfig) {
            SpringBootMockServletContext servletContext = new SpringBootMockServletContext(webMergedConfig.getResourceBasePath());
            initializers.add(0, new DefensiveWebApplicationContextInitializer(new ServletContextApplicationContextInitializer((ServletContext)servletContext, true)));
        }

        private static final class DefensiveWebApplicationContextInitializer
        implements ApplicationContextInitializer<ConfigurableApplicationContext> {
            private final ServletContextApplicationContextInitializer delegate;

            private DefensiveWebApplicationContextInitializer(ServletContextApplicationContextInitializer delegate) {
                this.delegate = delegate;
            }

            public void initialize(ConfigurableApplicationContext applicationContext) {
                if (applicationContext instanceof ConfigurableWebApplicationContext) {
                    ConfigurableWebApplicationContext webApplicationContext = (ConfigurableWebApplicationContext)applicationContext;
                    this.delegate.initialize(webApplicationContext);
                }
            }
        }
    }

    private class PrepareEnvironmentListener
    implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
    PriorityOrdered {
        private final MergedContextConfiguration mergedConfig;

        PrepareEnvironmentListener(MergedContextConfiguration mergedConfig) {
            this.mergedConfig = mergedConfig;
        }

        public int getOrder() {
            return Integer.MIN_VALUE;
        }

        public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
            SpringBootContextLoader.this.prepareEnvironment(this.mergedConfig, event.getSpringApplication(), event.getEnvironment(), true);
        }
    }

    private static class ContextCustomizerAdapter
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ContextCustomizer contextCustomizer;
        private final MergedContextConfiguration mergedConfig;

        ContextCustomizerAdapter(ContextCustomizer contextCustomizer, MergedContextConfiguration mergedConfig) {
            this.contextCustomizer = contextCustomizer;
            this.mergedConfig = mergedConfig;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            this.contextCustomizer.customizeContext(applicationContext, this.mergedConfig);
        }
    }

    @Order(value=-2147483648)
    private static class ParentContextApplicationContextInitializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        private final ApplicationContext parent;

        ParentContextApplicationContextInitializer(ApplicationContext parent) {
            this.parent = parent;
        }

        public void initialize(ConfigurableApplicationContext applicationContext) {
            applicationContext.setParent(this.parent);
        }
    }
}

