/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.properties;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.test.context.DynamicPropertyRegistry;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class TestcontainersPropertySource
extends EnumerablePropertySource<Map<String, Supplier<Object>>> {
    static final String NAME = "testcontainersPropertySource";
    private final DynamicPropertyRegistry registry = (name, valueSupplier) -> {
        Assert.hasText((String)name, (String)"'name' must not be null or blank");
        Assert.notNull((Object)valueSupplier, (String)"'valueSupplier' must not be null");
        valueSuppliers.put(name, valueSupplier);
    };

    TestcontainersPropertySource() {
        this(Collections.synchronizedMap(new LinkedHashMap()));
    }

    private TestcontainersPropertySource(Map<String, Supplier<Object>> valueSuppliers) {
        super(NAME, Collections.unmodifiableMap(valueSuppliers));
    }

    public Object getProperty(String name) {
        Supplier valueSupplier = (Supplier)((Map)this.source).get(name);
        return valueSupplier != null ? valueSupplier.get() : null;
    }

    public boolean containsProperty(String name) {
        return ((Map)this.source).containsKey(name);
    }

    public String[] getPropertyNames() {
        return StringUtils.toStringArray(((Map)this.source).keySet());
    }

    public static DynamicPropertyRegistry attach(Environment environment) {
        Assert.state((boolean)(environment instanceof ConfigurableEnvironment), (String)"TestcontainersPropertySource can only be attached to a ConfigurableEnvironment");
        return TestcontainersPropertySource.attach((ConfigurableEnvironment)environment);
    }

    private static DynamicPropertyRegistry attach(ConfigurableEnvironment environment) {
        PropertySource propertySource = environment.getPropertySources().get(NAME);
        if (propertySource == null) {
            environment.getPropertySources().addFirst((PropertySource)new TestcontainersPropertySource());
            return TestcontainersPropertySource.attach(environment);
        }
        Assert.state((boolean)(propertySource instanceof TestcontainersPropertySource), (String)"Incorrect TestcontainersPropertySource type registered");
        return ((TestcontainersPropertySource)propertySource).registry;
    }
}

