/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.lifecycle;

import java.util.Collection;
import org.springframework.core.env.ConfigurableEnvironment;
import org.testcontainers.lifecycle.Startable;
import org.testcontainers.lifecycle.Startables;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TestcontainersStartup {
    SEQUENTIAL{

        @Override
        void start(Collection<? extends Startable> startables) {
            startables.forEach(Startable::start);
        }
    }
    ,
    PARALLEL{

        @Override
        void start(Collection<? extends Startable> startables) {
            Startables.deepStart(startables).join();
        }
    };

    public static final String PROPERTY = "spring.testcontainers.beans.startup";

    abstract void start(Collection<? extends Startable> var1);

    static TestcontainersStartup get(ConfigurableEnvironment environment) {
        return TestcontainersStartup.get(environment != null ? environment.getProperty(PROPERTY) : null);
    }

    private static TestcontainersStartup get(String value) {
        if (value == null) {
            return SEQUENTIAL;
        }
        String canonicalName = TestcontainersStartup.getCanonicalName(value);
        for (TestcontainersStartup candidate : TestcontainersStartup.values()) {
            if (!candidate.name().equalsIgnoreCase(canonicalName)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("Unknown '%s' property value '%s'".formatted(PROPERTY, value));
    }

    private static String getCanonicalName(String name) {
        StringBuilder canonicalName = new StringBuilder(name.length());
        name.chars().filter(Character::isLetterOrDigit).map(Character::toLowerCase).forEach(c -> canonicalName.append((char)c));
        return canonicalName.toString();
    }
}

