/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.lang.reflect.Method;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.springframework.boot.context.embedded.tomcat.ServletContextInitializerLifecycleListener;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class TomcatEmbeddedContext
extends StandardContext {
    private ServletContextInitializerLifecycleListener starter;

    TomcatEmbeddedContext() {
    }

    public void loadOnStartup(Container[] children) {
    }

    public void deferredLoadOnStartup() {
        ClassLoader classLoader = this.getLoader().getClassLoader();
        ClassLoader existingLoader = null;
        if (classLoader != null) {
            existingLoader = ClassUtils.overrideThreadContextClassLoader((ClassLoader)classLoader);
        }
        if (ClassUtils.isPresent((String)"org.apache.catalina.deploy.ErrorPage", null)) {
            super.loadOnStartup(this.findChildren());
        } else {
            this.callSuper((Object)this, "loadOnStartup", this.findChildren(), Container[].class);
        }
        if (existingLoader != null) {
            ClassUtils.overrideThreadContextClassLoader((ClassLoader)existingLoader);
        }
    }

    public void setStarter(ServletContextInitializerLifecycleListener starter) {
        this.starter = starter;
    }

    public ServletContextInitializerLifecycleListener getStarter() {
        return this.starter;
    }

    private void callSuper(Object target, String name, Object value, Class<?> type) {
        Method method = ReflectionUtils.findMethod(target.getClass().getSuperclass(), (String)name, (Class[])new Class[]{type});
        ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])new Object[]{value});
    }
}

