/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.boot.bind.RelaxedDataBinderTests;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class BindingPreparationTests {
    @Test
    public void testBeanWrapperCreatesNewMaps() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        wrapper.getPropertyValue("nested[foo]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
    }

    @Test
    public void testBeanWrapperCreatesNewMapEntries() throws Exception {
        TargetWithNestedMapOfBean target = new TargetWithNestedMapOfBean();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        wrapper.getPropertyValue("nested[foo]");
        wrapper.setPropertyValue("nested[foo].foo", (Object)"bar");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo]"));
    }

    @Test
    public void testAutoGrowWithFuzzyNameCapitals() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        String result = binder.normalizePath((BeanWrapper)wrapper, "NESTED[foo][bar]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertEquals((Object)"nested[foo][bar]", (Object)result);
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo][bar]"));
    }

    @Test
    public void testAutoGrowWithFuzzyNameUnderscores() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        String result = binder.normalizePath((BeanWrapper)wrapper, "nes_ted[foo][bar]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertEquals((Object)"nested[foo][bar]", (Object)result);
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo][bar]"));
    }

    @Test
    public void testAutoGrowNewNestedMapOfMaps() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        String result = binder.normalizePath((BeanWrapper)wrapper, "nested[foo][bar]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertEquals((Object)"nested[foo][bar]", (Object)result);
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo][bar]"));
    }

    @Test
    public void testAutoGrowNewNestedMapOfBeans() throws Exception {
        TargetWithNestedMapOfBean target = new TargetWithNestedMapOfBean();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        String result = binder.normalizePath((BeanWrapper)wrapper, "nested[foo].foo");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertEquals((Object)"nested[foo].foo", (Object)result);
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo]"));
    }

    @Test
    public void testAutoGrowNewNestedMapOfBeansWithPeriod() throws Exception {
        TargetWithNestedMapOfBean target = new TargetWithNestedMapOfBean();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        String result = binder.normalizePath((BeanWrapper)wrapper, "nested.foo.foo");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertEquals((Object)"nested[foo].foo", (Object)result);
    }

    @Test
    public void testAutoGrowNewNestedMapOfListOfString() throws Exception {
        TargetWithNestedMapOfListOfString target = new TargetWithNestedMapOfListOfString();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        binder.normalizePath((BeanWrapper)wrapper, "nested[foo][0]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo]"));
    }

    @Test
    public void testAutoGrowListOfMaps() throws Exception {
        TargetWithNestedListOfMaps target = new TargetWithNestedListOfMaps();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        binder.normalizePath((BeanWrapper)wrapper, "nested[0][foo]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[0]"));
    }

    @Test
    public void testAutoGrowListOfLists() throws Exception {
        TargetWithNestedListOfLists target = new TargetWithNestedListOfLists();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        RelaxedDataBinder binder = new RelaxedDataBinder((Object)target);
        binder.normalizePath((BeanWrapper)wrapper, "nested[0][1]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[0][1]"));
    }

    @Test
    public void testBeanWrapperCreatesNewNestedMaps() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        wrapper.getPropertyValue("nested[foo]");
        wrapper.setPropertyValue("nested[foo]", new LinkedHashMap());
        wrapper.setPropertyValue("nested[foo]", new ArrayList());
        wrapper.setPropertyValue("nested[foo][0]", (Object)"bar");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo][0]"));
    }

    @Test
    public void testBeanWrapperCreatesNewObjects() throws Exception {
        RelaxedDataBinderTests.TargetWithNestedObject target = new RelaxedDataBinderTests.TargetWithNestedObject();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        wrapper.setPropertyValue("nested.foo", (Object)"bar");
        wrapper.getPropertyValue("nested");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
    }

    @Test
    public void testBeanWrapperLists() throws Exception {
        TargetWithNestedMapOfListOfString target = new TargetWithNestedMapOfListOfString();
        BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)target);
        wrapper.setAutoGrowNestedPaths(true);
        TypeDescriptor descriptor = wrapper.getPropertyTypeDescriptor("nested");
        Assert.assertTrue((boolean)descriptor.isMap());
        wrapper.getPropertyValue("nested[foo]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested"));
        wrapper.setPropertyValue("nested[foo][0]", (Object)"bar");
        wrapper.getPropertyValue("nested[foo][0]");
        Assert.assertNotNull((Object)wrapper.getPropertyValue("nested[foo]"));
    }

    @Test
    @Ignore(value="Work in progress")
    public void testExpressionLists() throws Exception {
        TargetWithNestedMapOfListOfString target = new TargetWithNestedMapOfListOfString();
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        target.setNested(map);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext((Object)target);
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        Expression expression = parser.parseExpression("nested.foo");
        Assert.assertNotNull((Object)expression.getValue((EvaluationContext)context));
    }

    public static class VanillaTarget {
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }

    public static class TargetWithNestedMapOfBean {
        private Map<String, VanillaTarget> nested;

        public Map<String, VanillaTarget> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, VanillaTarget> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedListOfLists {
        private List<List<String>> nested;

        public List<List<String>> getNested() {
            return this.nested;
        }

        public void setNested(List<List<String>> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedListOfMaps {
        private List<Map<String, String>> nested;

        public List<Map<String, String>> getNested() {
            return this.nested;
        }

        public void setNested(List<Map<String, String>> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMapOfListOfString {
        private Map<String, List<String>> nested;

        public Map<String, List<String>> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, List<String>> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMap {
        private Map<String, Object> nested;

        public Map<String, Object> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, Object> nested) {
            this.nested = nested;
        }
    }
}

