/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.constraints.NotNull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyValues;
import org.springframework.boot.bind.RelaxedDataBinder;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.LocalValidatorFactoryBean;

public class RelaxedDataBinderTests {
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ConversionService conversionService;

    @Test
    public void testBindString() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "foo: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
    }

    @Test
    public void testBindChars() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "bar: foo");
        Assert.assertEquals((Object)"foo", (Object)new String(target.getBar()));
    }

    @Test
    public void testBindStringWithPrefix() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "test.foo: bar", "test");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
    }

    @Test
    public void testBindFromEnvironmentStyleWithPrefix() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "TEST_FOO: bar", "test");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
    }

    @Test
    public void testBindFromEnvironmentStyleWithNestedPrefix() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "TEST_IT_FOO: bar", "test.it");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
    }

    @Test
    public void testBindCapitals() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "FOO: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
    }

    @Test
    public void testBindUnderscoreInActualPropertyName() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "foo-bar: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFoo_bar());
    }

    @Test
    public void testBindUnderscoreToCamelCase() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "foo_baz: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFooBaz());
    }

    @Test
    public void testBindHyphen() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "foo-baz: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFooBaz());
    }

    @Test
    public void testBindCamelCase() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "fooBaz: bar");
        Assert.assertEquals((Object)"bar", (Object)target.getFooBaz());
    }

    @Test
    public void testBindNumber() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.bind(target, "foo: bar\nvalue: 123");
        Assert.assertEquals((long)123L, (long)target.getValue());
    }

    @Test
    public void testSimpleValidation() throws Exception {
        ValidatedTarget target = new ValidatedTarget();
        BindingResult result = this.bind(target, "");
        Assert.assertEquals((long)1L, (long)result.getErrorCount());
    }

    @Test
    public void testRequiredFieldsValidation() throws Exception {
        TargetWithValidatedMap target = new TargetWithValidatedMap();
        BindingResult result = this.bind(target, "info[foo]: bar");
        Assert.assertEquals((long)2L, (long)result.getErrorCount());
        for (FieldError error : result.getFieldErrors()) {
            System.err.println(new StaticMessageSource().getMessage((MessageSourceResolvable)error, Locale.getDefault()));
        }
    }

    @Test
    public void testAllowedFields() throws Exception {
        VanillaTarget target = new VanillaTarget();
        RelaxedDataBinder binder = this.getBinder(target, null);
        binder.setAllowedFields(new String[]{"foo"});
        binder.setIgnoreUnknownFields(false);
        BindingResult result = this.bind((DataBinder)binder, target, "foo: bar\nvalue: 123\nbar: spam");
        Assert.assertEquals((long)0L, (long)target.getValue());
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
    }

    @Test
    public void testDisallowedFields() throws Exception {
        VanillaTarget target = new VanillaTarget();
        RelaxedDataBinder binder = this.getBinder(target, null);
        binder.setDisallowedFields(new String[]{"foo", "bar"});
        binder.setIgnoreUnknownFields(false);
        BindingResult result = this.bind((DataBinder)binder, target, "foo: bar\nvalue: 123\nbar: spam");
        Assert.assertEquals((long)123L, (long)target.getValue());
        Assert.assertNull((Object)target.getFoo());
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
    }

    @Test
    public void testBindNested() throws Exception {
        TargetWithNestedObject target = new TargetWithNestedObject();
        this.bind(target, "nested.foo: bar\nnested.value: 123");
        Assert.assertEquals((long)123L, (long)target.getNested().getValue());
    }

    @Test
    public void testBindNestedWithEnviromentStyle() throws Exception {
        TargetWithNestedObject target = new TargetWithNestedObject();
        this.bind(target, "nested_foo: bar\nnested_value: 123");
        Assert.assertEquals((long)123L, (long)target.getNested().getValue());
    }

    @Test
    public void testBindNestedList() throws Exception {
        TargetWithNestedList target = new TargetWithNestedList();
        this.bind(target, "nested[0]: bar\nnested[1]: foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test
    public void testBindNestedListCommaDelimitedOnly() throws Exception {
        TargetWithNestedList target = new TargetWithNestedList();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "nested: bar,foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test
    public void testBindNestedSetCommaDelimitedOnly() throws Exception {
        TargetWithNestedSet target = new TargetWithNestedSet();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "nested: bar,foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test(expected=NotWritablePropertyException.class)
    public void testBindNestedReadOnlyListCommaSeparated() throws Exception {
        TargetWithReadOnlyNestedList target = new TargetWithReadOnlyNestedList();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "nested: bar,foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test
    public void testBindNestedReadOnlyListIndexed() throws Exception {
        TargetWithReadOnlyNestedList target = new TargetWithReadOnlyNestedList();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "nested[0]: bar\nnested[1]:foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test
    public void testBindDoubleNestedReadOnlyListIndexed() throws Exception {
        TargetWithReadOnlyDoubleNestedList target = new TargetWithReadOnlyDoubleNestedList();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "bean.nested[0]:bar\nbean.nested[1]:foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getBean().getNested().toString());
    }

    @Test
    public void testBindNestedReadOnlyCollectionIndexed() throws Exception {
        TargetWithReadOnlyNestedCollection target = new TargetWithReadOnlyNestedCollection();
        this.conversionService = new DefaultConversionService();
        this.bind(target, "nested[0]: bar\nnested[1]:foo");
        Assert.assertEquals((Object)"[bar, foo]", (Object)target.getNested().toString());
    }

    @Test
    public void testBindNestedMap() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        this.bind(target, "nested.foo: bar\nnested.value: 123");
        Assert.assertEquals((Object)"123", (Object)target.getNested().get("value"));
    }

    @Test
    public void testBindNestedUntypedMap() throws Exception {
        TargetWithNestedUntypedMap target = new TargetWithNestedUntypedMap();
        this.bind(target, "nested.foo: bar\nnested.value: 123");
        Assert.assertEquals((Object)"123", target.getNested().get("value"));
    }

    @Test
    public void testBindNestedMapOfString() throws Exception {
        TargetWithNestedMapOfString target = new TargetWithNestedMapOfString();
        this.bind(target, "nested.foo: bar\nnested.value.foo: 123");
        Assert.assertEquals((Object)"bar", (Object)target.getNested().get("foo"));
        Assert.assertEquals((Object)"123", (Object)target.getNested().get("value.foo"));
    }

    @Test
    public void testBindNestedMapBracketReferenced() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        this.bind(target, "nested[foo]: bar\nnested[value]: 123");
        Assert.assertEquals((Object)"123", (Object)target.getNested().get("value"));
    }

    @Test
    public void testBindDoubleNestedMap() throws Exception {
        TargetWithNestedMap target = new TargetWithNestedMap();
        this.bind(target, "nested.foo: bar\nnested.bar.spam: bucket\nnested.bar.value: 123\nnested.bar.foo: crap");
        Assert.assertEquals((long)2L, (long)target.getNested().size());
        Assert.assertEquals((long)3L, (long)((Map)target.getNested().get("bar")).size());
        Assert.assertEquals((Object)"123", ((Map)target.getNested().get("bar")).get("value"));
        Assert.assertEquals((Object)"bar", (Object)target.getNested().get("foo"));
        Assert.assertFalse((boolean)target.getNested().containsValue(target.getNested()));
    }

    @Test
    public void testBindNestedMapOfListOfString() throws Exception {
        TargetWithNestedMapOfListOfString target = new TargetWithNestedMapOfListOfString();
        this.bind(target, "nested.foo[0]: bar\nnested.bar[0]: bucket\nnested.bar[1]: 123\nnested.bar[2]: crap");
        Assert.assertEquals((long)2L, (long)target.getNested().size());
        Assert.assertEquals((long)3L, (long)target.getNested().get("bar").size());
        Assert.assertEquals((Object)"123", (Object)target.getNested().get("bar").get(1));
        Assert.assertEquals((Object)"[bar]", (Object)target.getNested().get("foo").toString());
    }

    @Test
    public void testBindNestedMapOfBean() throws Exception {
        TargetWithNestedMapOfBean target = new TargetWithNestedMapOfBean();
        this.bind(target, "nested.foo.foo: bar\nnested.bar.foo: bucket");
        Assert.assertEquals((long)2L, (long)target.getNested().size());
        Assert.assertEquals((Object)"bucket", (Object)target.getNested().get("bar").getFoo());
    }

    @Test
    public void testBindNestedMapOfListOfBean() throws Exception {
        TargetWithNestedMapOfListOfBean target = new TargetWithNestedMapOfListOfBean();
        this.bind(target, "nested.foo[0].foo: bar\nnested.bar[0].foo: bucket\nnested.bar[1].value: 123\nnested.bar[2].foo: crap");
        Assert.assertEquals((long)2L, (long)target.getNested().size());
        Assert.assertEquals((long)3L, (long)target.getNested().get("bar").size());
        Assert.assertEquals((long)123L, (long)target.getNested().get("bar").get(1).getValue());
        Assert.assertEquals((Object)"bar", (Object)target.getNested().get("foo").get(0).getFoo());
    }

    @Test
    public void testBindErrorTypeMismatch() throws Exception {
        VanillaTarget target = new VanillaTarget();
        BindingResult result = this.bind(target, "foo: bar\nvalue: foo");
        Assert.assertEquals((long)1L, (long)result.getErrorCount());
    }

    @Test
    public void testBindErrorNotWritable() throws Exception {
        this.expected.expectMessage("property 'spam'");
        this.expected.expectMessage("not writable");
        VanillaTarget target = new VanillaTarget();
        BindingResult result = this.bind(target, "spam: bar\nvalue: 123");
        Assert.assertEquals((long)1L, (long)result.getErrorCount());
    }

    @Test
    public void testBindErrorNotWritableWithPrefix() throws Exception {
        VanillaTarget target = new VanillaTarget();
        BindingResult result = this.bind(target, "spam: bar\nvanilla.value: 123", "vanilla");
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
        Assert.assertEquals((long)123L, (long)target.getValue());
    }

    @Test
    public void testOnlyTopLevelFields() throws Exception {
        VanillaTarget target = new VanillaTarget();
        RelaxedDataBinder binder = this.getBinder(target, null);
        binder.setIgnoreUnknownFields(false);
        binder.setIgnoreNestedProperties(true);
        BindingResult result = this.bind((DataBinder)binder, target, "foo: bar\nvalue: 123\nnested.bar: spam");
        Assert.assertEquals((long)123L, (long)target.getValue());
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
    }

    @Test
    public void testNoNestedFields() throws Exception {
        VanillaTarget target = new VanillaTarget();
        RelaxedDataBinder binder = this.getBinder(target, "foo");
        binder.setIgnoreUnknownFields(false);
        binder.setIgnoreNestedProperties(true);
        BindingResult result = this.bind((DataBinder)binder, target, "foo.foo: bar\nfoo.value: 123\nfoo.nested.bar: spam");
        Assert.assertEquals((long)123L, (long)target.getValue());
        Assert.assertEquals((Object)"bar", (Object)target.getFoo());
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
    }

    @Test
    public void testBindMap() throws Exception {
        LinkedHashMap target = new LinkedHashMap();
        BindingResult result = this.bind(target, "spam: bar\nvanilla.value: 123", "vanilla");
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
        Assert.assertEquals((Object)"123", target.get("value"));
    }

    @Test
    public void testBindMapNestedMap() throws Exception {
        LinkedHashMap target = new LinkedHashMap();
        BindingResult result = this.bind(target, "spam: bar\nvanilla.foo.value: 123", "vanilla");
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
        Map map = (Map)target.get("foo");
        Assert.assertEquals((Object)"123", map.get("value"));
    }

    @Test
    public void testBindOverlappingNestedMaps() throws Exception {
        LinkedHashMap target = new LinkedHashMap();
        BindingResult result = this.bind(target, "a.b.c.d: abc\na.b.c1.d1: efg");
        Assert.assertEquals((long)0L, (long)result.getErrorCount());
        Map a = (Map)target.get("a");
        Map b = (Map)a.get("b");
        Map c = (Map)b.get("c");
        Assert.assertEquals((Object)"abc", c.get("d"));
        Map c1 = (Map)b.get("c1");
        Assert.assertEquals((Object)"efg", c1.get("d1"));
    }

    @Test
    public void testBindCaseInsensitiveEnumsWithoutConverter() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.doTestBindCaseInsensitiveEnums(target);
    }

    @Test
    public void testBindCaseInsensitiveEnumsWithConverter() throws Exception {
        VanillaTarget target = new VanillaTarget();
        this.conversionService = new DefaultConversionService();
        this.doTestBindCaseInsensitiveEnums(target);
    }

    private void doTestBindCaseInsensitiveEnums(VanillaTarget target) throws Exception {
        BindingResult result = this.bind(target, "bingo: THIS");
        Assert.assertThat((Object)result.getErrorCount(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)((Object)target.getBingo()), (Matcher)Matchers.equalTo((Object)((Object)Bingo.THIS)));
        result = this.bind(target, "bingo: oR");
        Assert.assertThat((Object)result.getErrorCount(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)((Object)target.getBingo()), (Matcher)Matchers.equalTo((Object)((Object)Bingo.or)));
        result = this.bind(target, "bingo: that");
        Assert.assertThat((Object)result.getErrorCount(), (Matcher)Matchers.equalTo((Object)0));
        Assert.assertThat((Object)((Object)target.getBingo()), (Matcher)Matchers.equalTo((Object)((Object)Bingo.THAT)));
    }

    private BindingResult bind(Object target, String values) throws Exception {
        return this.bind(target, values, null);
    }

    private BindingResult bind(DataBinder binder, Object target, String values) throws Exception {
        Properties properties = PropertiesLoaderUtils.loadProperties((Resource)new ByteArrayResource(values.getBytes()));
        binder.bind((PropertyValues)new MutablePropertyValues((Map)properties));
        binder.validate();
        return binder.getBindingResult();
    }

    private BindingResult bind(Object target, String values, String namePrefix) throws Exception {
        return this.bind((DataBinder)this.getBinder(target, namePrefix), target, values);
    }

    private RelaxedDataBinder getBinder(Object target, String namePrefix) {
        RelaxedDataBinder binder = new RelaxedDataBinder(target, namePrefix);
        binder.setIgnoreUnknownFields(false);
        LocalValidatorFactoryBean validatorFactoryBean = new LocalValidatorFactoryBean();
        validatorFactoryBean.afterPropertiesSet();
        binder.setValidator((Validator)validatorFactoryBean);
        binder.setConversionService(this.conversionService);
        return binder;
    }

    public static class ValidatedTarget {
        @NotNull
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }

    static enum Bingo {
        THIS,
        or,
        THAT;

    }

    public static class VanillaTarget {
        private String foo;
        private char[] bar;
        private int value;
        private String foo_bar;
        private String fooBaz;
        private Bingo bingo;

        public char[] getBar() {
            return this.bar;
        }

        public void setBar(char[] bar) {
            this.bar = bar;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getFoo_bar() {
            return this.foo_bar;
        }

        public void setFoo_bar(String foo_bar) {
            this.foo_bar = foo_bar;
        }

        public String getFooBaz() {
            return this.fooBaz;
        }

        public void setFooBaz(String fooBaz) {
            this.fooBaz = fooBaz;
        }

        public Bingo getBingo() {
            return this.bingo;
        }

        public void setBingo(Bingo bingo) {
            this.bingo = bingo;
        }
    }

    public static class TargetWithNestedObject {
        private VanillaTarget nested;

        public VanillaTarget getNested() {
            return this.nested;
        }

        public void setNested(VanillaTarget nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedSet {
        private Set<String> nested = new LinkedHashSet<String>();

        public Set<String> getNested() {
            return this.nested;
        }

        public void setNested(Set<String> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithReadOnlyNestedCollection {
        private final Collection<String> nested = new ArrayList<String>();

        public Collection<String> getNested() {
            return this.nested;
        }
    }

    public static class TargetWithReadOnlyDoubleNestedList {
        TargetWithReadOnlyNestedList bean = new TargetWithReadOnlyNestedList();

        public TargetWithReadOnlyNestedList getBean() {
            return this.bean;
        }
    }

    public static class TargetWithReadOnlyNestedList {
        private final List<String> nested = new ArrayList<String>();

        public List<String> getNested() {
            return this.nested;
        }
    }

    public static class TargetWithNestedList {
        private List<String> nested;

        public List<String> getNested() {
            return this.nested;
        }

        public void setNested(List<String> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMapOfBean {
        private Map<String, VanillaTarget> nested;

        public Map<String, VanillaTarget> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, VanillaTarget> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMapOfListOfBean {
        private Map<String, List<VanillaTarget>> nested;

        public Map<String, List<VanillaTarget>> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, List<VanillaTarget>> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMapOfListOfString {
        private Map<String, List<String>> nested;

        public Map<String, List<String>> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, List<String>> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMapOfString {
        private Map<String, String> nested;

        public Map<String, String> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, String> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedUntypedMap {
        private Map nested;

        public Map getNested() {
            return this.nested;
        }

        public void setNested(Map nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithNestedMap {
        private Map<String, Object> nested;

        public Map<String, Object> getNested() {
            return this.nested;
        }

        public void setNested(Map<String, Object> nested) {
            this.nested = nested;
        }
    }

    public static class TargetWithValidatedMap {
        @RequiredKeys(value={"foo", "value"})
        private Map<String, Object> info;

        public Map<String, Object> getInfo() {
            return this.info;
        }

        public void setInfo(Map<String, Object> nested) {
            this.info = nested;
        }
    }

    public static class RequiredKeysValidator
    implements ConstraintValidator<RequiredKeys, Map<String, Object>> {
        private String[] fields;

        public void initialize(RequiredKeys constraintAnnotation) {
            this.fields = constraintAnnotation.value();
        }

        public boolean isValid(Map<String, Object> value, ConstraintValidatorContext context) {
            boolean valid = true;
            for (String field : this.fields) {
                if (value.containsKey(field)) continue;
                context.buildConstraintViolationWithTemplate("Missing field ''" + field + "''").addConstraintViolation();
                valid = false;
            }
            return valid;
        }
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={RequiredKeysValidator.class})
    public static @interface RequiredKeys {
        public String[] value();

        public String message() default "Required fields are not provided for field ''{0}''";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }
}

