/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;

public class RelaxedPropertyResolverTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private StandardEnvironment environment;
    private RelaxedPropertyResolver resolver;
    private LinkedHashMap<String, Object> source;

    @Before
    public void setup() {
        this.environment = new StandardEnvironment();
        this.source = new LinkedHashMap();
        this.source.put("myString", "value");
        this.source.put("myobject", "object");
        this.source.put("myInteger", 123);
        this.source.put("myClass", "java.lang.String");
        this.environment.getPropertySources().addFirst((PropertySource)new MapPropertySource("test", this.source));
        this.resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment);
    }

    @Test
    public void needsPropertyResolver() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("PropertyResolver must not be null");
        new RelaxedPropertyResolver(null);
    }

    @Test
    public void getRequiredProperty() throws Exception {
        Assert.assertThat((Object)this.resolver.getRequiredProperty("my-string"), (Matcher)Matchers.equalTo((Object)"value"));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("required key [my-missing] not found");
        this.resolver.getRequiredProperty("my-missing");
    }

    @Test
    public void getRequiredPropertyWithType() throws Exception {
        Assert.assertThat((Object)this.resolver.getRequiredProperty("my-integer", Integer.class), (Matcher)Matchers.equalTo((Object)123));
        this.thrown.expect(IllegalStateException.class);
        this.thrown.expectMessage("required key [my-missing] not found");
        this.resolver.getRequiredProperty("my-missing", Integer.class);
    }

    @Test
    public void getProperty() throws Exception {
        Assert.assertThat((Object)this.resolver.getProperty("my-string"), (Matcher)Matchers.equalTo((Object)"value"));
        Assert.assertThat((Object)this.resolver.getProperty("my-missing"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void getPropertyNoSeparator() throws Exception {
        Assert.assertThat((Object)this.resolver.getProperty("myobject"), (Matcher)Matchers.equalTo((Object)"object"));
        Assert.assertThat((Object)this.resolver.getProperty("my-object"), (Matcher)Matchers.equalTo((Object)"object"));
    }

    @Test
    public void getPropertyWithDefault() throws Exception {
        Assert.assertThat((Object)this.resolver.getProperty("my-string", "a"), (Matcher)Matchers.equalTo((Object)"value"));
        Assert.assertThat((Object)this.resolver.getProperty("my-missing", "a"), (Matcher)Matchers.equalTo((Object)"a"));
    }

    @Test
    public void getPropertyWithType() throws Exception {
        Assert.assertThat((Object)this.resolver.getProperty("my-integer", Integer.class), (Matcher)Matchers.equalTo((Object)123));
        Assert.assertThat((Object)this.resolver.getProperty("my-missing", Integer.class), (Matcher)Matchers.nullValue());
    }

    @Test
    public void getPropertyWithTypeAndDefault() throws Exception {
        Assert.assertThat((Object)this.resolver.getProperty("my-integer", Integer.class, (Object)345), (Matcher)Matchers.equalTo((Object)123));
        Assert.assertThat((Object)this.resolver.getProperty("my-missing", Integer.class, (Object)345), (Matcher)Matchers.equalTo((Object)345));
    }

    @Test
    public void getPropertyAsClass() throws Exception {
        Assert.assertThat((Object)this.resolver.getPropertyAsClass("my-class", String.class), (Matcher)Matchers.equalTo(String.class));
        Assert.assertThat((Object)this.resolver.getPropertyAsClass("my-missing", String.class), (Matcher)Matchers.nullValue());
    }

    @Test
    public void containsProperty() throws Exception {
        Assert.assertThat((Object)this.resolver.containsProperty("my-string"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.resolver.containsProperty("myString"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.resolver.containsProperty("my_string"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.resolver.containsProperty("my-missing"), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void resolverPlaceholder() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.resolver.resolvePlaceholders("test");
    }

    @Test
    public void resolveRequiredPlaceholders() throws Exception {
        this.thrown.expect(UnsupportedOperationException.class);
        this.resolver.resolveRequiredPlaceholders("test");
    }

    @Test
    public void prefixed() throws Exception {
        this.resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "a.b.c.");
        this.source.put("a.b.c.d", "test");
        Assert.assertThat((Object)this.resolver.containsProperty("d"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.resolver.getProperty("d"), (Matcher)Matchers.equalTo((Object)"test"));
    }

    @Test
    public void prefixedRelaxed() throws Exception {
        this.resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "a.");
        this.source.put("A_B", "test");
        this.source.put("a.foobar", "spam");
        Assert.assertThat((Object)this.resolver.containsProperty("b"), (Matcher)Matchers.equalTo((Object)true));
        Assert.assertThat((Object)this.resolver.getProperty("b"), (Matcher)Matchers.equalTo((Object)"test"));
        Assert.assertThat((Object)this.resolver.getProperty("foo-bar"), (Matcher)Matchers.equalTo((Object)"spam"));
    }

    @Test
    public void subProperties() throws Exception {
        this.source.put("x.y.my-sub.a.b", "1");
        this.source.put("x.y.mySub.a.c", "2");
        this.source.put("x.y.MY_SUB.a.d", "3");
        this.resolver = new RelaxedPropertyResolver((PropertyResolver)this.environment, "x.y.");
        Map subProperties = this.resolver.getSubProperties("my-sub.");
        Assert.assertThat((Object)subProperties.size(), (Matcher)Matchers.equalTo((Object)3));
        Assert.assertThat(subProperties.get("a.b"), (Matcher)Matchers.equalTo((Object)"1"));
        Assert.assertThat(subProperties.get("a.c"), (Matcher)Matchers.equalTo((Object)"2"));
        Assert.assertThat(subProperties.get("a.d"), (Matcher)Matchers.equalTo((Object)"3"));
    }
}

