/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={TestConfig.class})
@IntegrationTest
public class SimplerPropertySourcesBindingTests {
    @Value(value="${foo:}")
    private String foo;
    @Autowired
    private Wrapper properties;

    @Test
    public void overridingOfPropertiesWorksAsExpected() {
        Assert.assertThat((Object)this.foo, (Matcher)Matchers.is((Object)this.properties.getFoo()));
    }

    @ConfigurationProperties
    public static class Wrapper {
        private String foo;

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }
    }

    @PropertySources(value={@PropertySource(value={"classpath:/override.properties"}), @PropertySource(value={"classpath:/some.properties"})})
    @Configuration
    @EnableConfigurationProperties(value={Wrapper.class})
    public static class TestConfig {
        @Bean
        public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
            return new PropertySourcesPlaceholderConfigurer();
        }
    }
}

