/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.bind;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Validation;
import javax.validation.constraints.NotNull;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.bind.YamlConfigurationFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.StaticMessageSource;
import org.springframework.validation.BindException;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlConfigurationFactoryTests {
    private Validator validator;
    private final Map<Class<?>, Map<String, String>> aliases = new HashMap();

    private Foo createFoo(String yaml) throws Exception {
        YamlConfigurationFactory factory = new YamlConfigurationFactory(Foo.class);
        factory.setYaml(yaml);
        factory.setExceptionIfInvalid(true);
        factory.setPropertyAliases(this.aliases);
        factory.setValidator(this.validator);
        factory.setMessageSource((MessageSource)new StaticMessageSource());
        factory.afterPropertiesSet();
        return (Foo)factory.getObject();
    }

    private Jee createJee(String yaml) throws Exception {
        YamlConfigurationFactory factory = new YamlConfigurationFactory(Jee.class);
        factory.setYaml(yaml);
        factory.setExceptionIfInvalid(true);
        factory.setPropertyAliases(this.aliases);
        factory.setValidator(this.validator);
        factory.setMessageSource((MessageSource)new StaticMessageSource());
        factory.afterPropertiesSet();
        return (Jee)factory.getObject();
    }

    @Test
    public void testValidYamlLoadsWithNoErrors() throws Exception {
        Foo foo = this.createFoo("name: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.bar);
    }

    @Test
    public void testValidYamlWithAliases() throws Exception {
        this.aliases.put(Foo.class, Collections.singletonMap("foo-name", "name"));
        Foo foo = this.createFoo("foo-name: blah\nbar: blah");
        Assert.assertEquals((Object)"blah", (Object)foo.name);
    }

    @Test(expected=YAMLException.class)
    public void unknownPropertyCausesLoadFailure() throws Exception {
        this.createFoo("hi: hello\nname: foo\nbar: blah");
    }

    @Test(expected=BindException.class)
    public void missingPropertyCausesValidationError() throws Exception {
        this.validator = new SpringValidatorAdapter(Validation.buildDefaultValidatorFactory().getValidator());
        this.createFoo("bar: blah");
    }

    @Test
    public void testWithPeriodInKey() throws Exception {
        Jee jee = this.createJee("mymap:\n  ? key1.key2\n  : value");
        Assert.assertEquals((Object)"value", (Object)jee.mymap.get("key1.key2"));
    }

    private static class Jee {
        public Map<Object, Object> mymap;

        private Jee() {
        }
    }

    private static class Foo {
        @NotNull
        public String name;
        public String bar;

        private Foo() {
        }
    }
}

