/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.lang.reflect.Field;
import java.util.EventListener;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.BDDMockito;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.MockEmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationListener;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.Ordered;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.SessionScope;

public class EmbeddedWebApplicationContextTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private EmbeddedWebApplicationContext context;

    @Before
    public void setup() {
        this.context = new EmbeddedWebApplicationContext();
    }

    @After
    public void cleanup() {
        this.context.close();
    }

    @Test
    public void startRegistrations() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        Assert.assertThat((Object)this.context.getServletContext(), (Matcher)org.hamcrest.Matchers.equalTo((Object)escf.getServletContext()));
        ((ServletContext)Mockito.verify((Object)escf.getServletContext())).setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
        Assert.assertThat((Object)this.context.getBeanFactory().getRegisteredScope("session"), (Matcher)org.hamcrest.Matchers.instanceOf(SessionScope.class));
        Assert.assertThat((Object)this.context.containsBean("servletContext"), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
    }

    @Test
    public void doesNotRegistersShutdownHook() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.refresh();
        Field shutdownHookField = AbstractApplicationContext.class.getDeclaredField("shutdownHook");
        shutdownHookField.setAccessible(true);
        Object shutdownHook = shutdownHookField.get(this.context);
        Assert.assertThat((Object)shutdownHook, (Matcher)org.hamcrest.Matchers.nullValue());
    }

    @Test
    public void containerEventPublished() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.registerBeanDefinition("listener", (BeanDefinition)new RootBeanDefinition(MockListener.class));
        this.context.refresh();
        EmbeddedServletContainerInitializedEvent event = ((MockListener)this.context.getBean(MockListener.class)).getEvent();
        Assert.assertNotNull((Object)event);
        Assert.assertTrue((event.getSource().getPort() >= 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.context, (Object)event.getApplicationContext());
    }

    @Test
    public void stopOnClose() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        this.context.close();
        ((MockEmbeddedServletContainerFactory.MockEmbeddedServletContainer)Mockito.verify((Object)escf.getContainer())).stop();
    }

    @Test
    public void cannotSecondRefresh() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.refresh();
        this.thrown.expect(IllegalStateException.class);
        this.context.refresh();
    }

    @Test
    public void servletContextAwareBeansAreInjected() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        ServletContextAware bean = (ServletContextAware)Mockito.mock(ServletContextAware.class);
        this.context.registerBeanDefinition("bean", this.beanDefinition(bean));
        this.context.refresh();
        ((ServletContextAware)Mockito.verify((Object)bean)).setServletContext(this.getEmbeddedServletContainerFactory().getServletContext());
    }

    @Test
    public void missingEmbeddedServletContainerFactory() throws Exception {
        this.thrown.expect(ApplicationContextException.class);
        this.thrown.expectMessage("Unable to start EmbeddedWebApplicationContext due to missing EmbeddedServletContainerFactory bean");
        this.context.refresh();
    }

    @Test
    public void tooManyEmbeddedServletContainerFactories() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        this.context.registerBeanDefinition("embeddedServletContainerFactory2", (BeanDefinition)new RootBeanDefinition(MockEmbeddedServletContainerFactory.class));
        this.thrown.expect(ApplicationContextException.class);
        this.thrown.expectMessage("Unable to start EmbeddedWebApplicationContext due to multiple EmbeddedServletContainerFactory beans");
        this.context.refresh();
    }

    @Test
    public void singleServletBean() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Servlet servlet = (Servlet)Mockito.mock(Servlet.class);
        this.context.registerBeanDefinition("servletBean", this.beanDefinition(servlet));
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        ((ServletContext)Mockito.verify((Object)escf.getServletContext())).addServlet("servletBean", servlet);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(0).getRegistration())).addMapping(new String[]{"/"});
    }

    @Test
    public void multipleServletBeans() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Servlet servlet1 = (Servlet)Mockito.mock(Servlet.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)servlet1).getOrder()).willReturn((Object)1);
        Servlet servlet2 = (Servlet)Mockito.mock(Servlet.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)servlet2).getOrder()).willReturn((Object)2);
        this.context.registerBeanDefinition("servletBean2", this.beanDefinition(servlet2));
        this.context.registerBeanDefinition("servletBean1", this.beanDefinition(servlet1));
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        ServletContext servletContext = escf.getServletContext();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{servletContext});
        ((ServletContext)ordered.verify((Object)servletContext)).addServlet("servletBean1", servlet1);
        ((ServletContext)ordered.verify((Object)servletContext)).addServlet("servletBean2", servlet2);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(0).getRegistration())).addMapping(new String[]{"/servletBean1/"});
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(1).getRegistration())).addMapping(new String[]{"/servletBean2/"});
    }

    @Test
    public void multipleServletBeansWithMainDispatcher() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Servlet servlet1 = (Servlet)Mockito.mock(Servlet.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)servlet1).getOrder()).willReturn((Object)1);
        Servlet servlet2 = (Servlet)Mockito.mock(Servlet.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)servlet2).getOrder()).willReturn((Object)2);
        this.context.registerBeanDefinition("servletBean2", this.beanDefinition(servlet2));
        this.context.registerBeanDefinition("dispatcherServlet", this.beanDefinition(servlet1));
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        ServletContext servletContext = escf.getServletContext();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{servletContext});
        ((ServletContext)ordered.verify((Object)servletContext)).addServlet("dispatcherServlet", servlet1);
        ((ServletContext)ordered.verify((Object)servletContext)).addServlet("servletBean2", servlet2);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(0).getRegistration())).addMapping(new String[]{"/"});
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(1).getRegistration())).addMapping(new String[]{"/servletBean2/"});
    }

    @Test
    public void servletAndFilterBeans() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Servlet servlet = (Servlet)Mockito.mock(Servlet.class);
        Filter filter1 = (Filter)Mockito.mock(Filter.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)filter1).getOrder()).willReturn((Object)1);
        Filter filter2 = (Filter)Mockito.mock(Filter.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)filter2).getOrder()).willReturn((Object)2);
        this.context.registerBeanDefinition("servletBean", this.beanDefinition(servlet));
        this.context.registerBeanDefinition("filterBean2", this.beanDefinition(filter2));
        this.context.registerBeanDefinition("filterBean1", this.beanDefinition(filter1));
        this.context.refresh();
        MockEmbeddedServletContainerFactory escf = this.getEmbeddedServletContainerFactory();
        ServletContext servletContext = escf.getServletContext();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{servletContext});
        ((ServletContext)Mockito.verify((Object)escf.getServletContext())).addServlet("servletBean", servlet);
        ((ServletRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredServlet(0).getRegistration())).addMapping(new String[]{"/"});
        ((ServletContext)ordered.verify((Object)escf.getServletContext())).addFilter("filterBean1", filter1);
        ((ServletContext)ordered.verify((Object)escf.getServletContext())).addFilter("filterBean2", filter2);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredFilter(0).getRegistration())).addMappingForUrlPatterns(FilterRegistrationBean.ASYNC_DISPATCHER_TYPES, false, new String[]{"/*"});
        ((FilterRegistration.Dynamic)Mockito.verify((Object)escf.getRegisteredFilter(1).getRegistration())).addMappingForUrlPatterns(FilterRegistrationBean.ASYNC_DISPATCHER_TYPES, false, new String[]{"/*"});
    }

    @Test
    public void servletContextInitializerBeans() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        ServletContextInitializer initializer1 = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)initializer1).getOrder()).willReturn((Object)1);
        ServletContextInitializer initializer2 = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{Ordered.class}));
        BDDMockito.given((Object)((Ordered)initializer2).getOrder()).willReturn((Object)2);
        this.context.registerBeanDefinition("initializerBean2", this.beanDefinition(initializer2));
        this.context.registerBeanDefinition("initializerBean1", this.beanDefinition(initializer1));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        InOrder ordered = Mockito.inOrder((Object[])new Object[]{initializer1, initializer2});
        ((ServletContextInitializer)ordered.verify((Object)initializer1)).onStartup(servletContext);
        ((ServletContextInitializer)ordered.verify((Object)initializer2)).onStartup(servletContext);
    }

    @Test
    public void servletContextListenerBeans() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        ServletContextListener initializer = (ServletContextListener)Mockito.mock(ServletContextListener.class);
        this.context.registerBeanDefinition("initializerBean", this.beanDefinition(initializer));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        ((ServletContext)Mockito.verify((Object)servletContext)).addListener((EventListener)initializer);
    }

    @Test
    public void unorderedServletContextInitializerBeans() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        ServletContextInitializer initializer1 = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class);
        ServletContextInitializer initializer2 = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class);
        this.context.registerBeanDefinition("initializerBean2", this.beanDefinition(initializer2));
        this.context.registerBeanDefinition("initializerBean1", this.beanDefinition(initializer1));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        ((ServletContextInitializer)Mockito.verify((Object)initializer1)).onStartup(servletContext);
        ((ServletContextInitializer)Mockito.verify((Object)initializer2)).onStartup(servletContext);
    }

    @Test
    public void servletContextInitializerBeansDoesNotSkipServletsAndFilters() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        ServletContextInitializer initializer = (ServletContextInitializer)Mockito.mock(ServletContextInitializer.class);
        Servlet servlet = (Servlet)Mockito.mock(Servlet.class);
        Filter filter = (Filter)Mockito.mock(Filter.class);
        this.context.registerBeanDefinition("initializerBean", this.beanDefinition(initializer));
        this.context.registerBeanDefinition("servletBean", this.beanDefinition(servlet));
        this.context.registerBeanDefinition("filterBean", this.beanDefinition(filter));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        ((ServletContextInitializer)Mockito.verify((Object)initializer)).onStartup(servletContext);
        ((ServletContext)Mockito.verify((Object)servletContext)).addServlet(Matchers.anyString(), (Servlet)Matchers.anyObject());
        ((ServletContext)Mockito.verify((Object)servletContext)).addFilter(Matchers.anyString(), (Filter)Matchers.anyObject());
    }

    @Test
    public void servletContextInitializerBeansSkipsRegisteredServletsAndFilters() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Servlet servlet = (Servlet)Mockito.mock(Servlet.class);
        Filter filter = (Filter)Mockito.mock(Filter.class);
        ServletRegistrationBean initializer = new ServletRegistrationBean(servlet, new String[]{"/foo"});
        this.context.registerBeanDefinition("initializerBean", this.beanDefinition(initializer));
        this.context.registerBeanDefinition("servletBean", this.beanDefinition(servlet));
        this.context.registerBeanDefinition("filterBean", this.beanDefinition(filter));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        ((ServletContext)Mockito.verify((Object)servletContext, (VerificationMode)Mockito.atMost((int)1))).addServlet(Matchers.anyString(), (Servlet)Matchers.anyObject());
        ((ServletContext)Mockito.verify((Object)servletContext, (VerificationMode)Mockito.atMost((int)1))).addFilter(Matchers.anyString(), (Filter)Matchers.anyObject());
    }

    @Test
    public void filterReegistrationBeansSkipsRegisteredFilters() throws Exception {
        this.addEmbeddedServletContainerFactoryBean();
        Filter filter = (Filter)Mockito.mock(Filter.class);
        FilterRegistrationBean initializer = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        this.context.registerBeanDefinition("initializerBean", this.beanDefinition(initializer));
        this.context.registerBeanDefinition("filterBean", this.beanDefinition(filter));
        this.context.refresh();
        ServletContext servletContext = this.getEmbeddedServletContainerFactory().getServletContext();
        ((ServletContext)Mockito.verify((Object)servletContext, (VerificationMode)Mockito.atMost((int)1))).addFilter(Matchers.anyString(), (Filter)Matchers.anyObject());
    }

    @Test
    public void postProcessEmbeddedServletContainerFactory() throws Exception {
        RootBeanDefinition bd = new RootBeanDefinition(MockEmbeddedServletContainerFactory.class);
        MutablePropertyValues pv = new MutablePropertyValues();
        pv.add("port", (Object)"${port}");
        bd.setPropertyValues(pv);
        this.context.registerBeanDefinition("embeddedServletContainerFactory", (BeanDefinition)bd);
        PropertySourcesPlaceholderConfigurer propertySupport = new PropertySourcesPlaceholderConfigurer();
        Properties properties = new Properties();
        properties.put("port", (Object)8080);
        propertySupport.setProperties(properties);
        this.context.registerBeanDefinition("propertySupport", this.beanDefinition(propertySupport));
        this.context.refresh();
        Assert.assertThat((Object)this.getEmbeddedServletContainerFactory().getContainer().getPort(), (Matcher)org.hamcrest.Matchers.equalTo((Object)8080));
    }

    private void addEmbeddedServletContainerFactoryBean() {
        this.context.registerBeanDefinition("embeddedServletContainerFactory", (BeanDefinition)new RootBeanDefinition(MockEmbeddedServletContainerFactory.class));
    }

    public MockEmbeddedServletContainerFactory getEmbeddedServletContainerFactory() {
        return (MockEmbeddedServletContainerFactory)((Object)this.context.getBean(MockEmbeddedServletContainerFactory.class));
    }

    private BeanDefinition beanDefinition(Object bean) {
        RootBeanDefinition beanDefinition = new RootBeanDefinition();
        beanDefinition.setBeanClass(this.getClass());
        beanDefinition.setFactoryMethodName("getBean");
        ConstructorArgumentValues constructorArguments = new ConstructorArgumentValues();
        constructorArguments.addGenericArgumentValue(bean);
        beanDefinition.setConstructorArgumentValues(constructorArguments);
        return beanDefinition;
    }

    public static <T> T getBean(T object) {
        return object;
    }

    public static class MockListener
    implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
        private EmbeddedServletContainerInitializedEvent event;

        public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
            this.event = event;
        }

        public EmbeddedServletContainerInitializedEvent getEvent() {
            return this.event;
        }
    }
}

