/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.BDDMockito;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.embedded.MockFilter;
import org.springframework.boot.context.embedded.ServletRegistrationBean;

public class FilterRegistrationBeanTests {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final MockFilter filter = new MockFilter();
    @Mock
    private ServletContext servletContext;
    @Mock
    private FilterRegistration.Dynamic registration;

    @Before
    public void setupMocks() {
        MockitoAnnotations.initMocks((Object)this);
        BDDMockito.given((Object)this.servletContext.addFilter(Matchers.anyString(), (Filter)Matchers.anyObject())).willReturn((Object)this.registration);
    }

    @Test
    public void startupWithDefaults() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addFilter("mockFilter", (Filter)this.filter);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).setAsyncSupported(true);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForUrlPatterns(FilterRegistrationBean.ASYNC_DISPATCHER_TYPES, false, new String[]{"/*"});
    }

    @Test
    public void startupWithSpecifiedValues() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setName("test");
        bean.setFilter((Filter)this.filter);
        bean.setAsyncSupported(false);
        bean.setInitParameters(Collections.singletonMap("a", "b"));
        bean.addInitParameter("c", "d");
        bean.setUrlPatterns(new LinkedHashSet<String>(Arrays.asList("/a", "/b")));
        bean.addUrlPatterns(new String[]{"/c"});
        bean.setServletNames(new LinkedHashSet<String>(Arrays.asList("s1", "s2")));
        bean.addServletNames(new String[]{"s3"});
        bean.setServletRegistrationBeans(Collections.singleton(this.mockServletRegistation("s4")));
        bean.addServletRegistrationBeans(new ServletRegistrationBean[]{this.mockServletRegistation("s5")});
        bean.setMatchAfter(true);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addFilter("test", (Filter)this.filter);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).setAsyncSupported(false);
        HashMap<String, String> expectedInitParameters = new HashMap<String, String>();
        expectedInitParameters.put("a", "b");
        expectedInitParameters.put("c", "d");
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).setInitParameters(expectedInitParameters);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForUrlPatterns(FilterRegistrationBean.NON_ASYNC_DISPATCHER_TYPES, true, new String[]{"/a", "/b", "/c"});
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForServletNames(FilterRegistrationBean.NON_ASYNC_DISPATCHER_TYPES, true, new String[]{"s4", "s5", "s1", "s2", "s3"});
    }

    @Test
    public void specificName() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setName("specificName");
        bean.setFilter((Filter)this.filter);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addFilter("specificName", (Filter)this.filter);
    }

    @Test
    public void deducedName() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)this.filter);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext)).addFilter("mockFilter", (Filter)this.filter);
    }

    @Test
    public void disable() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        bean.setFilter((Filter)this.filter);
        bean.setEnabled(false);
        bean.onStartup(this.servletContext);
        ((ServletContext)Mockito.verify((Object)this.servletContext, (VerificationMode)Mockito.times((int)0))).addFilter("mockFilter", (Filter)this.filter);
    }

    @Test
    public void setFilterMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Filter must not be null");
        bean.onStartup(this.servletContext);
    }

    @Test
    public void createServletMustNotBeNull() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Filter must not be null");
        new FilterRegistrationBean(null, new ServletRegistrationBean[0]);
    }

    @Test
    public void setServletRegistrationBeanMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ServletRegistrationBeans must not be null");
        bean.setServletRegistrationBeans(null);
    }

    @Test
    public void createServletRegistrationBeanMustNotBeNull() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ServletRegistrationBeans must not be null");
        new FilterRegistrationBean((Filter)this.filter, (ServletRegistrationBean[])null);
    }

    @Test
    public void addServletRegistrationBeanMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ServletRegistrationBeans must not be null");
        bean.addServletRegistrationBeans((ServletRegistrationBean[])null);
    }

    @Test
    public void setServletRegistrationBeanReplacesValue() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[]{this.mockServletRegistation("a")});
        bean.setServletRegistrationBeans(new LinkedHashSet<ServletRegistrationBean>(Arrays.asList(this.mockServletRegistation("b"))));
        bean.onStartup(this.servletContext);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForServletNames(FilterRegistrationBean.ASYNC_DISPATCHER_TYPES, false, new String[]{"b"});
    }

    @Test
    public void modifyInitParameters() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        bean.addInitParameter("a", "b");
        bean.getInitParameters().put("a", "c");
        bean.onStartup(this.servletContext);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).setInitParameters(Collections.singletonMap("a", "c"));
    }

    @Test
    public void setUrlPatternMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("UrlPatterns must not be null");
        bean.setUrlPatterns(null);
    }

    @Test
    public void addUrlPatternMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("UrlPatterns must not be null");
        bean.addUrlPatterns((String[])null);
    }

    @Test
    public void setServletNameMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ServletNames must not be null");
        bean.setServletNames(null);
    }

    @Test
    public void addServletNameMustNotBeNull() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("ServletNames must not be null");
        bean.addServletNames((String[])null);
    }

    @Test
    public void withSpecificDispatcherTypes() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        bean.setDispatcherTypes(DispatcherType.INCLUDE, new DispatcherType[]{DispatcherType.FORWARD});
        bean.onStartup(this.servletContext);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForUrlPatterns(EnumSet.of(DispatcherType.INCLUDE, DispatcherType.FORWARD), false, new String[]{"/*"});
    }

    @Test
    public void withSpecificDispatcherTypesEnumSet() throws Exception {
        FilterRegistrationBean bean = new FilterRegistrationBean((Filter)this.filter, new ServletRegistrationBean[0]);
        EnumSet<DispatcherType> types = EnumSet.of(DispatcherType.INCLUDE, DispatcherType.FORWARD);
        bean.setDispatcherTypes(types);
        bean.onStartup(this.servletContext);
        ((FilterRegistration.Dynamic)Mockito.verify((Object)this.registration)).addMappingForUrlPatterns(types, false, new String[]{"/*"});
    }

    private ServletRegistrationBean mockServletRegistation(String name) {
        ServletRegistrationBean bean = new ServletRegistrationBean();
        bean.setName(name);
        return bean;
    }
}

