/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import javax.servlet.MultipartConfigElement;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.boot.context.embedded.MultipartConfigFactory;

public class MultipartConfigFactoryTests {
    @Test
    public void sensibleDefaults() {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        MultipartConfigElement config = factory.createMultipartConfig();
        Assert.assertThat((Object)config.getLocation(), (Matcher)Matchers.equalTo((Object)""));
        Assert.assertThat((Object)config.getMaxFileSize(), (Matcher)Matchers.equalTo((Object)-1L));
        Assert.assertThat((Object)config.getMaxRequestSize(), (Matcher)Matchers.equalTo((Object)-1L));
        Assert.assertThat((Object)config.getFileSizeThreshold(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void create() throws Exception {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setLocation("loc");
        factory.setMaxFileSize(1L);
        factory.setMaxRequestSize(2L);
        factory.setFileSizeThreshold(3);
        MultipartConfigElement config = factory.createMultipartConfig();
        Assert.assertThat((Object)config.getLocation(), (Matcher)Matchers.equalTo((Object)"loc"));
        Assert.assertThat((Object)config.getMaxFileSize(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)config.getMaxRequestSize(), (Matcher)Matchers.equalTo((Object)2L));
        Assert.assertThat((Object)config.getFileSizeThreshold(), (Matcher)Matchers.equalTo((Object)3));
    }

    @Test
    public void createWithStringSizes() throws Exception {
        MultipartConfigFactory factory = new MultipartConfigFactory();
        factory.setMaxFileSize("1");
        factory.setMaxRequestSize("2kB");
        factory.setFileSizeThreshold("3Mb");
        MultipartConfigElement config = factory.createMultipartConfig();
        Assert.assertThat((Object)config.getMaxFileSize(), (Matcher)Matchers.equalTo((Object)1L));
        Assert.assertThat((Object)config.getMaxRequestSize(), (Matcher)Matchers.equalTo((Object)2048L));
        Assert.assertThat((Object)config.getFileSizeThreshold(), (Matcher)Matchers.equalTo((Object)0x300000));
    }
}

