/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.springframework.boot.context.embedded.AbstractEmbeddedServletContainerFactoryTests;
import org.springframework.boot.context.embedded.ServletContextInitializer;
import org.springframework.boot.context.embedded.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatContextCustomizer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainer;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.util.SocketUtils;

public class TomcatEmbeddedServletContainerFactoryTests
extends AbstractEmbeddedServletContainerFactoryTests {
    protected TomcatEmbeddedServletContainerFactory getFactory() {
        return new TomcatEmbeddedServletContainerFactory(0);
    }

    @Test
    public void tomcatEngineNames() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        factory.setPort(SocketUtils.findAvailableTcpPort((int)40000));
        TomcatEmbeddedServletContainer container2 = (TomcatEmbeddedServletContainer)factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        String firstContainerName = ((TomcatEmbeddedServletContainer)this.container).getTomcat().getEngine().getName();
        String secondContainerName = container2.getTomcat().getEngine().getName();
        Assert.assertFalse((String)"Tomcat engines must have different names", (boolean)firstContainerName.equals(secondContainerName));
        container2.stop();
    }

    @Test
    public void tomcatListeners() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        LifecycleListener[] listeners = new LifecycleListener[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (LifecycleListener)Mockito.mock(LifecycleListener.class);
        }
        factory.setContextLifecycleListeners(Arrays.asList(listeners[0], listeners[1]));
        factory.addContextLifecycleListeners(new LifecycleListener[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (LifecycleListener listener : listeners) {
            ((LifecycleListener)ordered.verify((Object)listener)).lifecycleEvent((LifecycleEvent)org.mockito.Matchers.anyObject());
        }
    }

    @Test
    public void tomcatCustomizers() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        TomcatContextCustomizer[] listeners = new TomcatContextCustomizer[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (TomcatContextCustomizer)Mockito.mock(TomcatContextCustomizer.class);
        }
        factory.setTomcatContextCustomizers(Arrays.asList(listeners[0], listeners[1]));
        factory.addContextCustomizers(new TomcatContextCustomizer[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (TomcatContextCustomizer listener : listeners) {
            ((TomcatContextCustomizer)ordered.verify((Object)listener)).customize((Context)org.mockito.Matchers.anyObject());
        }
    }

    @Test
    public void tomcatConnectorCustomizers() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        TomcatConnectorCustomizer[] listeners = new TomcatConnectorCustomizer[4];
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i] = (TomcatConnectorCustomizer)Mockito.mock(TomcatConnectorCustomizer.class);
        }
        factory.setTomcatConnectorCustomizers(Arrays.asList(listeners[0], listeners[1]));
        factory.addConnectorCustomizers(new TomcatConnectorCustomizer[]{listeners[2], listeners[3]});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        InOrder ordered = Mockito.inOrder((Object[])listeners);
        for (TomcatConnectorCustomizer listener : listeners) {
            ((TomcatConnectorCustomizer)ordered.verify((Object)listener)).customize((Connector)org.mockito.Matchers.anyObject());
        }
    }

    @Test
    public void tomcatAdditionalConnectors() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        Connector[] listeners = new Connector[4];
        for (int i = 0; i < listeners.length; ++i) {
            Connector connector = (Connector)Mockito.mock(Connector.class);
            BDDMockito.given((Object)connector.getState()).willReturn((Object)LifecycleState.STOPPED);
            listeners[i] = connector;
        }
        factory.addAdditionalTomcatConnectors(listeners);
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        Map connectors = ((TomcatEmbeddedServletContainer)this.container).getServiceConnectors();
        Assert.assertThat((Object)((Connector[])connectors.values().iterator().next()).length, (Matcher)Matchers.equalTo((Object)(listeners.length + 1)));
    }

    @Test
    public void addNullAdditionalConnectorThrows() {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Connectors must not be null");
        factory.addAdditionalTomcatConnectors((Connector[])null);
    }

    @Test
    public void sessionTimeout() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(10);
        this.assertTimeout(factory, 10);
    }

    @Test
    public void sessionTimeoutInMins() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setSessionTimeout(1, TimeUnit.MINUTES);
        this.assertTimeout(factory, 60);
    }

    @Test
    public void valve() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        Valve valve = (Valve)Mockito.mock(Valve.class);
        factory.addContextValves(new Valve[]{valve});
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        ((Valve)Mockito.verify((Object)valve)).setNext((Valve)org.mockito.Matchers.any(Valve.class));
    }

    @Test
    public void setNullTomcatContextCustomizersThrows() {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TomcatContextCustomizers must not be null");
        factory.setTomcatContextCustomizers(null);
    }

    @Test
    public void addNullContextCustomizersThrows() {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TomcatContextCustomizers must not be null");
        factory.addContextCustomizers((TomcatContextCustomizer[])null);
    }

    @Test
    public void setNullTomcatConnectorCustomizersThrows() {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TomcatConnectorCustomizers must not be null");
        factory.setTomcatConnectorCustomizers(null);
    }

    @Test
    public void addNullConnectorCustomizersThrows() {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("TomcatConnectorCustomizers must not be null");
        factory.addConnectorCustomizers((TomcatConnectorCustomizer[])null);
    }

    @Test
    public void uriEncoding() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        factory.setUriEncoding("US-ASCII");
        Tomcat tomcat = this.getTomcat(factory);
        Assert.assertEquals((Object)"US-ASCII", (Object)tomcat.getConnector().getURIEncoding());
    }

    @Test
    public void defaultUriEncoding() throws Exception {
        TomcatEmbeddedServletContainerFactory factory = this.getFactory();
        Tomcat tomcat = this.getTomcat(factory);
        Assert.assertEquals((Object)"UTF-8", (Object)tomcat.getConnector().getURIEncoding());
    }

    private void assertTimeout(TomcatEmbeddedServletContainerFactory factory, int expected) {
        Tomcat tomcat = this.getTomcat(factory);
        Context context = (Context)tomcat.getHost().findChildren()[0];
        Assert.assertThat((Object)context.getSessionTimeout(), (Matcher)Matchers.equalTo((Object)expected));
    }

    private Tomcat getTomcat(TomcatEmbeddedServletContainerFactory factory) {
        this.container = factory.getEmbeddedServletContainer(new ServletContextInitializer[0]);
        return ((TomcatEmbeddedServletContainer)this.container).getTomcat();
    }
}

