/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.LogManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.SLF4JLogFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingApplicationListener;
import org.springframework.boot.logging.java.JavaLoggingSystem;
import org.springframework.boot.test.EnvironmentTestUtils;
import org.springframework.boot.test.OutputCapture;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class LoggingApplicationListenerTests {
    private static final String[] NO_ARGS = new String[0];
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public OutputCapture outputCapture = new OutputCapture();
    private final LoggingApplicationListener initializer = new LoggingApplicationListener();
    private final Log logger = new SLF4JLogFactory().getInstance(this.getClass());
    private final SpringApplication springApplication = new SpringApplication(new Object[0]);
    private final GenericApplicationContext context = new GenericApplicationContext();

    @Before
    public void init() throws SecurityException, IOException {
        LogManager.getLogManager().readConfiguration(JavaLoggingSystem.class.getResourceAsStream("logging.properties"));
        this.initializer.onApplicationEvent((ApplicationEvent)new ApplicationStartedEvent(new SpringApplication(new Object[0]), NO_ARGS));
        new File("target/foo.log").delete();
        new File(this.tmpDir() + "/spring.log").delete();
    }

    @After
    public void clear() {
        System.clearProperty("LOG_FILE");
        System.clearProperty("LOG_PATH");
        System.clearProperty("PID");
        if (this.context != null) {
            this.context.close();
        }
    }

    private String tmpDir() {
        String path = this.context.getEnvironment().resolvePlaceholders("${java.io.tmpdir}");
        if ((path = path.replace("\\", "/")).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Test
    public void baseConfigLocation() {
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertFalse((String)("Wrong output:\n" + output), (boolean)output.contains("???"));
        Assert.assertTrue((boolean)new File(this.tmpDir() + "/spring.log").exists());
    }

    @Test
    public void overrideConfigLocation() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.config: classpath:logback-nondefault.xml"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.contains("Hello world"));
        Assert.assertFalse((String)("Wrong output:\n" + output), (boolean)output.contains("???"));
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith(this.tmpDir() + "/tmp.log"));
    }

    @Test
    public void overrideConfigDoesNotExist() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.config: doesnotexist.xml"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
    }

    @Test
    public void addLogFileProperty() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.config: classpath:logback-nondefault.xml", "logging.file: target/foo.log"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        Log logger = LogFactory.getLog(LoggingApplicationListenerTests.class);
        logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith("target/foo.log"));
    }

    @Test
    public void addLogFilePropertyWithDefault() {
        Assert.assertFalse((boolean)new File("target/foo.log").exists());
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.file: target/foo.log"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        Log logger = LogFactory.getLog(LoggingApplicationListenerTests.class);
        logger.info((Object)"Hello world");
        Assert.assertTrue((boolean)new File("target/foo.log").exists());
    }

    @Test
    public void addLogPathProperty() {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.config: classpath:logback-nondefault.xml", "logging.path: target/foo/"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        Log logger = LogFactory.getLog(LoggingApplicationListenerTests.class);
        logger.info((Object)"Hello world");
        String output = this.outputCapture.toString().trim();
        Assert.assertTrue((String)("Wrong output:\n" + output), (boolean)output.startsWith("target/foo/tmp.log"));
    }

    @Test
    public void parseDebugArg() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"debug"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        this.logger.trace((Object)"testattrace");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testatdebug"));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testattrace")));
    }

    @Test
    public void parseTraceArg() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"trace"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        this.logger.trace((Object)"testattrace");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testatdebug"));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testattrace"));
    }

    @Test
    public void parseLevels() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.level.org.springframework.boot=TRACE"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        this.logger.trace((Object)"testattrace");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testatdebug"));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"testattrace"));
    }

    @Test
    public void parseLevelsFails() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.level.org.springframework.boot=GARBAGE"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.containsString((String)"Cannot set level: GARBAGE"));
    }

    @Test
    public void parseLevelsNone() throws Exception {
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"logging.level.org.springframework.boot=OFF"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        this.logger.fatal((Object)"testatfatal");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatfatal")));
    }

    @Test
    public void parseArgsDisabled() throws Exception {
        this.initializer.setParseArgs(false);
        EnvironmentTestUtils.addEnvironment((ConfigurableApplicationContext)this.context, (String[])new String[]{"debug"});
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
    }

    @Test
    public void parseArgsDoesntReplace() throws Exception {
        this.initializer.setSpringBootLogging(LogLevel.ERROR);
        this.initializer.setParseArgs(false);
        this.initializer.onApplicationEvent((ApplicationEvent)new ApplicationStartedEvent(this.springApplication, new String[]{"--debug"}));
        this.initializer.initialize(this.context.getEnvironment(), this.context.getClassLoader());
        this.logger.debug((Object)"testatdebug");
        Assert.assertThat((Object)this.outputCapture.toString(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"testatdebug")));
    }
}

