/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.BDDMockito;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.logging.logback.LevelRemappingAppender;

public class LevelRemappingAppenderTests {
    private TestableLevelRemappingAppender appender;
    @Mock
    private LevelRemappingAppender.AppendableLogger logger;
    @Captor
    private ArgumentCaptor<ILoggingEvent> logCaptor;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.appender = (TestableLevelRemappingAppender)((Object)Mockito.spy((Object)((Object)new TestableLevelRemappingAppender())));
    }

    @Test
    public void useRootLoggerIfNoDestination() throws Exception {
        this.appender.append(this.mockLogEvent(Level.INFO));
        ((TestableLevelRemappingAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).getLogger("ROOT");
    }

    @Test
    public void useSpecificDestination() throws Exception {
        this.appender.setDestinationLogger("org.mine");
        this.appender.append(this.mockLogEvent(Level.INFO));
        ((TestableLevelRemappingAppender)((Object)Mockito.verify((Object)((Object)this.appender)))).getLogger("org.mine");
    }

    @Test
    public void defaltRemapsInfo() throws Exception {
        this.appender.append(this.mockLogEvent(Level.INFO));
        ((LevelRemappingAppender.AppendableLogger)Mockito.verify((Object)this.logger)).callAppenders((ILoggingEvent)this.logCaptor.capture());
        Assert.assertThat((Object)((ILoggingEvent)this.logCaptor.getValue()).getLevel(), (Matcher)Matchers.equalTo((Object)Level.DEBUG));
    }

    @Test
    public void customRemaps() throws Exception {
        this.appender.setRemapLevels("DEBUG->TRACE,ERROR->WARN");
        this.appender.append(this.mockLogEvent(Level.DEBUG));
        this.appender.append(this.mockLogEvent(Level.ERROR));
        ((LevelRemappingAppender.AppendableLogger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)2))).callAppenders((ILoggingEvent)this.logCaptor.capture());
        Assert.assertThat((Object)((ILoggingEvent)this.logCaptor.getAllValues().get(0)).getLevel(), (Matcher)Matchers.equalTo((Object)Level.TRACE));
        Assert.assertThat((Object)((ILoggingEvent)this.logCaptor.getAllValues().get(1)).getLevel(), (Matcher)Matchers.equalTo((Object)Level.WARN));
    }

    private ILoggingEvent mockLogEvent(Level level) {
        ILoggingEvent event = (ILoggingEvent)Mockito.mock(ILoggingEvent.class);
        BDDMockito.given((Object)event.getLevel()).willReturn((Object)level);
        return event;
    }

    private class TestableLevelRemappingAppender
    extends LevelRemappingAppender {
        private TestableLevelRemappingAppender() {
        }

        protected LevelRemappingAppender.AppendableLogger getLogger(String name) {
            return LevelRemappingAppenderTests.this.logger;
        }
    }
}

