/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.SpringApplicationContextLoader;
import org.springframework.test.context.MergedContextConfiguration;

public class SpringApplicationContextLoaderTests {
    private final SpringApplicationContextLoader loader = new SpringApplicationContextLoader();

    @Test
    public void environmentPropertiesSimple() {
        Map<String, Object> config = this.getEnvironmentProperties(SimpleConfig.class);
        this.assertKey(config, "key", "myValue");
        this.assertKey(config, "anotherKey", "anotherValue");
    }

    @Test
    public void environmentPropertiesSeparatorInValue() {
        Map<String, Object> config = this.getEnvironmentProperties(SameSeparatorInValue.class);
        this.assertKey(config, "key", "my=Value");
        this.assertKey(config, "anotherKey", "another:Value");
    }

    @Test
    public void environmentPropertiesAnotherSeparatorInValue() {
        Map<String, Object> config = this.getEnvironmentProperties(AnotherSeparatorInValue.class);
        this.assertKey(config, "key", "my:Value");
        this.assertKey(config, "anotherKey", "another=Value");
    }

    private Map<String, Object> getEnvironmentProperties(Class<?> testClass) {
        MergedContextConfiguration configuration = (MergedContextConfiguration)Mockito.mock(MergedContextConfiguration.class);
        ((MergedContextConfiguration)Mockito.doReturn(testClass).when((Object)configuration)).getTestClass();
        return this.loader.getEnvironmentProperties(configuration);
    }

    private void assertKey(Map<String, Object> actual, String key, Object value) {
        Assert.assertTrue((String)("Key '" + key + "' not found"), (boolean)actual.containsKey(key));
        Assert.assertEquals((Object)value, (Object)actual.get(key));
    }

    @IntegrationTest(value={"key=my:Value", "anotherKey:another=Value"})
    static class AnotherSeparatorInValue {
        AnotherSeparatorInValue() {
        }
    }

    @IntegrationTest(value={"key=my=Value", "anotherKey:another:Value"})
    static class SameSeparatorInValue {
        SameSeparatorInValue() {
        }
    }

    @IntegrationTest(value={"key=myValue", "anotherKey:anotherValue"})
    static class SimpleConfig {
        SimpleConfig() {
        }
    }
}

