/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;

@RunWith(value=SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes={Config.class})
@WebAppConfiguration
@IntegrationTest(value={"server.port=0", "value=123"})
public class SpringApplicationIntegrationTestTests {
    @Value(value="${local.server.port}")
    private int port = 0;
    @Value(value="${value}")
    private int value = 0;

    @Test
    public void runAndTestHttpEndpoint() {
        Assert.assertNotEquals((long)8080L, (long)this.port);
        Assert.assertNotEquals((long)0L, (long)this.port);
        String body = (String)new RestTemplate().getForObject("http://localhost:" + this.port + "/", String.class, new Object[0]);
        Assert.assertEquals((Object)"Hello World", (Object)body);
    }

    @Test
    public void annotationAttributesOverridePropertiesFile() throws Exception {
        Assert.assertEquals((long)123L, (long)this.value);
    }

    @Configuration
    @EnableWebMvc
    @RestController
    protected static class Config {
        @Value(value="${server.port:8080}")
        private int port = 8080;

        protected Config() {
        }

        @Bean
        public DispatcherServlet dispatcherServlet() {
            return new DispatcherServlet();
        }

        @Bean
        public EmbeddedServletContainerFactory embeddedServletContainer() {
            TomcatEmbeddedServletContainerFactory factory = new TomcatEmbeddedServletContainerFactory();
            factory.setPort(this.port);
            return factory;
        }

        @Bean
        public static PropertySourcesPlaceholderConfigurer propertyPlaceholder() {
            return new PropertySourcesPlaceholderConfigurer();
        }

        @RequestMapping(value={"/"})
        public String home() {
            return "Hello World";
        }
    }
}

